package ru.yandex.direct.proxy.model.web.callstep.specialserializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import static ru.yandex.direct.proxy.model.web.callstep.CallStepSuccessResponse.RESULT;

public abstract class BaseResultSerializer<T> extends JsonSerializer<T> {
    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers)
            throws IOException
    {
        gen.writeObjectFieldStart(RESULT);
        writeResult(value, gen);
        gen.writeEndObject();
    }

    protected abstract void writeResult(T value, JsonGenerator gen);


    @Override
    public abstract Class<T> handledType();
}
