package ru.yandex.direct.proxy.model.web.callstep.specialserializers;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.google.common.collect.Maps;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

import static java.util.Arrays.asList;

public class CallStepResultJsonSerializationFacade {
    private final Map<Class<?>, BaseResultSerializer<?>> supportMap;

    public CallStepResultJsonSerializationFacade() {
        List<BaseResultSerializer<?>> customSerializers = Collections.singletonList(new JooqRecordSerializer());
        this.supportMap = Maps.uniqueIndex(customSerializers, BaseResultSerializer::handledType);
    }

    public <X, T extends JsonSerializer<X>> T getSerializer(X object) {
        return (T) EntryStream.of(supportMap).filterKeys(x -> x.isInstance(object))
                .findFirst()
                .orElseThrow(() -> new IllegalStateException("there is no serializer for the object's class"))
                .getValue();
    }

    public boolean hasSerializer(Object object) {
        return StreamEx.of(supportMap.keySet()).anyMatch(x -> x.isInstance(object));
    }
}
