package ru.yandex.direct.proxy.model.web.callstep.specialserializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import one.util.streamex.StreamEx;
import org.jooq.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqRecordSerializer extends BaseResultSerializer<Record> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void writeResult(Record value, JsonGenerator gen) {
        StreamEx.of(value.fields())
                .forEach(x -> {
                    try {
                        gen.writeObjectField(x.getName(), value.get(x.getName()));
                    } catch (IOException e) {
                        log.warn("cannot convert to json" + value.get(x.getName()));
                    }
                });
    }

    @Override
    public Class<Record> handledType() {
        return Record.class;
    }
}
