package ru.yandex.direct.proxy.service;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.autotests.directapi.steps.UserSteps;
import ru.yandex.direct.proxy.model.StepTimeWrapper;
import ru.yandex.direct.proxy.model.web.InitStepRequest;

import static ru.yandex.direct.proxy.service.Utils.DEFAULT_TOKEN;
import static ru.yandex.direct.proxy.service.Utils.getStepsMap;

@Service
public class AliveService {
    private final RemoveStepService removeStepService;
    private final TokenStorageService tokenStorageService;

    @Autowired
    public AliveService(RemoveStepService removeStepService,
                        TokenStorageService tokenStorageService) {
        this.removeStepService = removeStepService;
        this.tokenStorageService = tokenStorageService;
    }

    public boolean isAlive() {
        return true;
    }

    public boolean stepsIsAccessible() {
        String subject = "zajigalka-rus";
        try {
            StepTimeWrapper stepTimeWrapper = getOrCreateDefaultStepTimeWrapper(DEFAULT_TOKEN);
            UserSteps userSteps = stepTimeWrapper.getSteps(UserSteps.class);
            List<Long> campaignIds = userSteps.campaignSteps().getAllCampaignIds(subject);
            return !campaignIds.isEmpty();
        } finally {
            removeStepService.remove(DEFAULT_TOKEN);
        }
    }

    private StepTimeWrapper getOrCreateDefaultStepTimeWrapper(String token) {
        StepTimeWrapper stepTimeWrapper = tokenStorageService.get(token);
        if (stepTimeWrapper != null) {
            return stepTimeWrapper;
        }
        InitStepRequest initStepRequest = new InitStepRequest().withLogin("at-direct-super");
        Map<Class, Object> stepsMap = getStepsMap(initStepRequest);
        StepTimeWrapper wrapper = new StepTimeWrapper(stepsMap, initStepRequest);
        tokenStorageService.put(token, wrapper, initStepRequest);
        return wrapper;
    }
}
