package ru.yandex.direct.proxy.service;

import java.util.Map;

import org.springframework.stereotype.Service;

import ru.yandex.direct.proxy.model.StepTimeWrapper;
import ru.yandex.direct.proxy.model.web.InitStepRequest;

import static ru.yandex.direct.proxy.service.Utils.getStepsMap;

@Service
public class InitStepService {
    private final GetTokenService getTokenService;
    private final TokenStorageService tokenStorageService;

    public InitStepService(GetTokenService getTokenService, TokenStorageService tokenStorageService)
    {
        this.getTokenService = getTokenService;
        this.tokenStorageService = tokenStorageService;
    }

    public String initSteps(InitStepRequest initStepRequest) {
        String token;
        token = tokenStorageService.tryToGetTokenByRequest(initStepRequest);
        if (token != null) {
            return token;
        }

        Map<Class, Object> stepsMap = getStepsMap(initStepRequest);
        token = getTokenService.createToken();

        tokenStorageService.put(token, new StepTimeWrapper(stepsMap, initStepRequest), initStepRequest);
        return token;
    }

}
