package ru.yandex.direct.proxy.service;

import java.lang.reflect.Constructor;
import java.util.List;

import one.util.streamex.StreamEx;
import org.jooq.TableRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectGenerator {
    private static final Logger log = LoggerFactory.getLogger(ObjectGenerator.class);
    private static final String DEFAULT_VALUE = "1";

    private ObjectGenerator() {
    }

    public static Object generate(Class<?> target) {
        log.info(target.getCanonicalName());
        if (target == Object.class || target == String.class) {
            return DEFAULT_VALUE;
        }
        if (target == Character.class || target == char.class) {
            return DEFAULT_VALUE.charAt(0);
        }
        if (target == Byte.class || target == byte.class) {
            return Byte.parseByte(DEFAULT_VALUE);
        }
        if (target == Short.class || target == short.class) {
            return Short.parseShort(DEFAULT_VALUE);
        }
        if (target == Integer.class || target == int.class) {
            return Integer.parseInt(DEFAULT_VALUE);
        }
        if (target == Long.class || target == long.class) {
            return Long.parseLong(DEFAULT_VALUE);
        }
        if (target == Float.class || target == float.class) {
            return Float.parseFloat(DEFAULT_VALUE);
        }
        if (target == Double.class || target == double.class) {
            return Double.parseDouble(DEFAULT_VALUE);
        }
        if (target == Boolean.class || target == boolean.class) {
            return Boolean.parseBoolean(DEFAULT_VALUE);
        }
        if (target.isEnum()) {
            return target.getEnumConstants()[0];
        }

        if (target.isArray()) {
            return new Object[]{generate(target.getComponentType())};
        }

        if (target.getConstructors().length == 0) {
            return null;
        }
        if (TableRecord.class.isAssignableFrom(target)) {
            return null;
        }
        Constructor<?> firstConstructor = StreamEx.of(target.getConstructors())
                .sortedBy(constructor -> constructor.getParameters().length)
                .findFirst()
                .orElseThrow(IllegalStateException::new);

        Class<?>[] parameterTypes = firstConstructor.getParameterTypes();

        if (parameterTypes.length == 0) {
            try {
                return target.newInstance();
            } catch (Exception ignored) {
                return null;
            }
        }
        List<Object> parameters = StreamEx.of(parameterTypes)
                .map(ObjectGenerator::generate)
                .toList();
        try {
            return firstConstructor.newInstance(parameters.toArray());
        } catch (Exception ignored) {
            return null;
        }
    }
}
