package ru.yandex.direct.proxy.service;

import org.springframework.stereotype.Service;

@Service
public class RemoveStepService {
    private final TokenStorageService tokenStorageService;
    private final TokenValidationService tokenValidationService;

    public RemoveStepService(TokenStorageService tokenStorageService,
            TokenValidationService tokenValidationService)
    {
        this.tokenStorageService = tokenStorageService;
        this.tokenValidationService = tokenValidationService;
    }

    public Object remove(String token) {
        if (!tokenValidationService.validate(token)) {
            return "invalid token";
        }
        tokenStorageService.remove(token);
        return true;
    }
}
