package ru.yandex.direct.proxy.service;

import java.util.List;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Service;

import ru.yandex.direct.proxy.model.web.SearchResponseItem;

import static ru.yandex.direct.proxy.model.Converter.toStepItems;

@Service
public class SearchStepService {
    private final StepsStorage stepsStorage;

    public SearchStepService(StepsStorage stepsStorage) {
        this.stepsStorage = stepsStorage;
    }

    public List<SearchResponseItem> search(List<String> substrings) {

        return StreamEx.of(substrings)
                .mapToEntry(stepsStorage::searchSteps)
                .mapKeyValue(
                        (substring, steps) -> new SearchResponseItem().withStepItems(toStepItems(steps))
                                .withSubstring(substring))
                .toList();
    }
}
