package ru.yandex.direct.proxy.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;

import ru.yandex.direct.proxy.model.StepTimeWrapper;
import ru.yandex.direct.proxy.model.web.InitStepRequest;

import static ru.yandex.direct.proxy.model.StepTypeEnum.CMD;

public class TokenStorageService {
    //чтобы избежать повторного создания токена -- будем отдавать уже существующий, если есть
    private final ConcurrentHashMap<InitStepRequest, String> tokenByRequest;

    private final Cache<String, StepTimeWrapper> stepsCache;

    public TokenStorageService(ConcurrentHashMap<InitStepRequest, String> tokenByRequest, Cache<String,
            StepTimeWrapper> stepsCache) {
        this.tokenByRequest = tokenByRequest;
        this.stepsCache = stepsCache;
    }

    public String tryToGetTokenByRequest(InitStepRequest request) {
        if (request.getStepsTypeEnum() == CMD) {
            return null;
        }
        if (!tokenByRequest.containsKey(request)) {
            return null;
        }
        String token = tokenByRequest.get(request);
        StepTimeWrapper stepTimeWrapper = get(token);
        if (stepTimeWrapper == null) {
            tokenByRequest.remove(request);
            return null;
        }
        return token;
    }

    public void put(String key, StepTimeWrapper wrapper, InitStepRequest request) {
        stepsCache.put(key, wrapper);
        tokenByRequest.put(request, key);
    }

    public boolean contains(String key) {
        return get(key) != null;
    }

    public StepTimeWrapper get(String key) {
        return stepsCache.getIfPresent(key);
    }

    public void remove(String key) {
        stepsCache.invalidate(key);
    }

    public Map<String, StepTimeWrapper> getAllSteps() {
        return stepsCache.asMap();
    }

    public CacheStats getStats() {
        return stepsCache.stats();
    }
}
