package ru.yandex.direct.proxy.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.primitives.Primitives;
import one.util.streamex.StreamEx;

import ru.yandex.autotests.direct.cmd.DirectCmdSteps;
import ru.yandex.autotests.direct.cmd.rules.ApiStepsRule;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.api.steps.DirectWebApiSteps;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.steps.UserSteps;
import ru.yandex.direct.proxy.model.StepTypeEnum;
import ru.yandex.direct.proxy.model.web.InitStepRequest;

import static ru.yandex.direct.proxy.model.StepTypeEnum.API;
import static ru.yandex.direct.proxy.model.StepTypeEnum.CMD;
import static ru.yandex.direct.proxy.model.StepTypeEnum.DARK_SIDE;
import static ru.yandex.direct.proxy.model.StepTypeEnum.DB;
import static ru.yandex.direct.proxy.model.StepTypeEnum.JAVA_WEB;

public final class Utils {
    static final String DEFAULT_TOKEN = "default_token";

    private Utils() {
    }

    static Map<Class, Object> getStepsMap(InitStepRequest initStepRequest) {
        DirectTestRunProperties directTestRunProperties = DirectTestRunProperties.getInstance();
        directTestRunProperties.setDirectUseIpv6(true);

        if (initStepRequest.getBalanceStageType() != null) {
            directTestRunProperties.setBalanceStageType(initStepRequest.getBalanceStageType());
        }
        if (initStepRequest.getDirectStage() != null) {
            directTestRunProperties.setDirectStage(initStepRequest.getDirectStage());
        }
        if (initStepRequest.getLocale() != null) {
            directTestRunProperties.setDirectApiLocale(initStepRequest.getLocale());
        }
        if (initStepRequest.getDirectApiSandBoxUiStage() != null) {
            directTestRunProperties.setDirectApiSandboxUIStage(initStepRequest.getDirectApiSandBoxUiStage());
        }

        ApiStepsRule apiStepsRule = new ApiStepsRule(directTestRunProperties);

        if (initStepRequest.getLogin() != null) {
            apiStepsRule.as(initStepRequest.getLogin());
        }

        DirectCmdSteps directCmdSteps = new DirectCmdSteps(directTestRunProperties);

        if (initStepRequest.getLogin() != null) {
            directCmdSteps.authSteps().authenticate(User.get(initStepRequest.getLogin()));
        }

        String directStage = initStepRequest.getDirectStage() == null ? "TS" : initStepRequest.getDirectStage();
        String host = directTestRunProperties.resolveDirectStageTypeToHost(directStage).replace("https://", "");

        DirectJooqDbSteps directJooqDbSteps = new DirectJooqDbSteps(host);

        if (initStepRequest.getShardForLogin() != null && initStepRequest.getShardForDbStep() != null) {
            throw new IllegalArgumentException("Недопустимо совместное использование полей shardForLogin "
                    + "и shardForDbStep, укажите только одно значение");

        } else if (initStepRequest.getShardForLogin() != null) {
            directJooqDbSteps.useShardForLogin(initStepRequest.getShardForLogin());
        } else if (initStepRequest.getShardForDbStep() != null) {
            directJooqDbSteps.useShard(initStepRequest.getShardForDbStep());
        } else if (initStepRequest.getLogin() != null) {
            directJooqDbSteps.useShardForLogin(initStepRequest.getLogin());
        }

        DarkSideSteps darkSideSteps = new DarkSideSteps(directTestRunProperties);

        DirectWebApiSteps directWebApiSteps = new DirectWebApiSteps(directTestRunProperties);

        Map<Class, Object> stepsMap = new HashMap<>();
        stepsMap.put(UserSteps.class, apiStepsRule.userSteps());
        stepsMap.put(directCmdSteps.getClass(), directCmdSteps);
        stepsMap.put(directJooqDbSteps.getClass(), directJooqDbSteps);
        stepsMap.put(darkSideSteps.getClass(), darkSideSteps);
        stepsMap.put(directWebApiSteps.getClass(), directWebApiSteps);
        return stepsMap;
    }

    public static BiMap<Class<?>, StepTypeEnum> createStepClassToTypeMap() {
        return ImmutableBiMap.<Class<?>, StepTypeEnum>builder()
                .put(UserSteps.class, API)
                .put(DarkSideSteps.class, DARK_SIDE)
                .put(DirectJooqDbSteps.class, DB)
                .put(DirectCmdSteps.class, CMD)
                .put(DirectWebApiSteps.class, JAVA_WEB)
                .build();
    }

    public static List<? extends Class<?>> parameterClasses(java.lang.reflect.Parameter[] parameters) {
        return StreamEx.of(parameters)
                .map(java.lang.reflect.Parameter::getType)
                .map(Primitives::wrap)
                .toList();
    }
}
