package ru.yandex.autotests.direct.steps;

import ru.yandex.autotests.direct.httpclient.core.DirectResponse;
import ru.yandex.autotests.direct.httpclient.data.sandbox.APISandboxClientTypeEnum;
import ru.yandex.autotests.direct.httpclient.data.sandbox.SandboxResponseBean;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class SandboxSteps extends BaseDirectSteps {

    @Step("Инициализация песочницы: login {0}, type {1}, initData {2}")
    public void enableSandbox(String login, APISandboxClientTypeEnum clientType, boolean initTestData) {
        enableSandbox(login, clientType, initTestData, Currency.YND_FIXED, false);
    }

    @Step("Инициализация песочницы: login {0}, type {1}, initData {2}")
    public void enableSandbox(
            String login,
            APISandboxClientTypeEnum clientType,
            boolean initTestData,
            Currency initialCurrency,
            boolean enableSharedAccount) {
        User user = User.get(login);
        steps().cmd().oldSteps().onPassport().authoriseAs(login, user.getPassword());
        DirectResponse response = steps().cmd().oldSteps().apiSandboxSteps()
                .startUseSandboxAPI(clientType, initTestData, initialCurrency, enableSharedAccount);
        assumeThat("Не удалось инициировать песочницу для пользователя " + login,
                response.getStatusLine().getStatusCode(), equalTo(200));

        String sandboxToken = extractSandboxToken(response);
        if (sandboxToken == null) {
            throw new DirectAPIException("Вернулся пустой sandbox token. ");
        }
        user.setSandboxToken(sandboxToken);
        User.saveUser(user);
        getLog().info("Обновлен sandbox token пользователя " + login);
    }

    @Step("Остановка песочницы: login {0}")
    public void closeSandbox(String login) {
        User user = User.get(login);
        steps().cmd().onPassport().authoriseAs(login, user.getPassword());
        DirectResponse response = steps().cmd().oldSteps().apiSandboxSteps().stopUseSandboxAPI();
        assumeThat("удалось закрыть песочницу для пользователя " + login,
                response.getStatusLine().getStatusCode(), equalTo(200));

    }

    private String extractSandboxToken(DirectResponse response) {
        SandboxResponseBean sandBean;
        try {
            sandBean = SandboxResponseBean.readJson(response.getResponseContent().toString());
        } catch (RuntimeException ex) {
            throw new DirectAPIException("Не удалось извлечь sandbox token. ", ex);
        }
        return sandBean.getCurrentSandboxState().getMasterToken();
    }
}