package ru.yandex.autotests.direct.utils;

import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.ArrayUtils;

/*
* Базовый класс для всех степовых классов
*
*/
public abstract class BaseSteps<T> {
    private T context;

    protected BaseSteps() {
    }

    private static MultiKeyMap<MultiKey<Object>, BaseSteps> steps;

    private static MultiKey<Object> getKey(Class<? extends BaseSteps> stepsClass,
                                           Object context,
                                           Object... additionalKeys) {
        additionalKeys = ArrayUtils.add(additionalKeys, stepsClass);
        additionalKeys = ArrayUtils.add(additionalKeys, context);
        return new MultiKey<>(additionalKeys);
    }

    protected static MultiKeyMap<MultiKey<Object>, BaseSteps> getSteps() {
        if (steps == null) {
            steps = new MultiKeyMap<>();
        }
        return steps;

    }

    protected void init(T context) {
        this.context = context;
    }

    public static <S extends BaseSteps, T> S getInstance(Class<S> stepsClass,
                                                         T context,
                                                         Object... additionalKeys) {
        MultiKey key = getKey(stepsClass, context, additionalKeys);

        if (!getSteps().containsKey(key)) {
            try {
                BaseSteps<T> stepsInstance = stepsClass.newInstance();
                stepsInstance.init(context);
                getSteps().put(key, stepsInstance);
            } catch (InstantiationException | IllegalAccessException e) {
                throw new DirectUtilsException("Cannot instantiate steps " + stepsClass.getName(), e);
            }
        }
        return (S) getSteps().get(key);
    }

    public T getContext() {
        return context;
    }
}
