package ru.yandex.autotests.direct.utils;

import ru.yandex.autotests.direct.utils.converter.ForecastTotalConverter;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.common.api45mng.ForecastCommonInfo;
import ru.yandex.autotests.directapi.common.api45mng.GetForecastInfo;

import java.math.RoundingMode;
import java.util.Arrays;

import static ch.lambdaj.Lambda.convert;
import static ch.lambdaj.Lambda.sum;
import static ch.lambdaj.Lambda.sumFrom;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 23.12.13
 * Time: 14:06
 * To change this template use File | Settings | File Templates.
 */
public class ForecastCalculator {
    public static float getCTR(int clicks, int shows){
        if (shows==0){
            return 0;
        }
        return Money.valueOf(clicks * 100.0/shows).setScale(2, RoundingMode.HALF_DOWN).floatValue();
    }

    public static float getTotal(int clicks, float price){

        return Money.valueOf(clicks * price).setScale(2, RoundingMode.HALF_DOWN).floatValue();
    }

    public static ForecastCommonInfo calculate(GetForecastInfo o) {
        ForecastCommonInfo result = new ForecastCommonInfo();
        result.setGeo(o.getCommon().getGeo());
        result.setClicks(sumFrom(Arrays.asList(o.getPhrases())).getClicks());
        result.setPremiumClicks(sumFrom(Arrays.asList(o.getPhrases())).getPremiumClicks());
        result.setFirstPlaceClicks(sumFrom(Arrays.asList(o.getPhrases())).getFirstPlaceClicks());
        result.setShows(sumFrom(Arrays.asList(o.getPhrases())).getShows());
        result.setMin(Money.valueOf((Double)sum(convert(o.getPhrases(),
                new ForecastTotalConverter(ForecastTotalConverter.FieldType.MIN)))).floatValue());
        result.setPremiumMin(Money.valueOf((Double) sum(convert(o.getPhrases(),
                new ForecastTotalConverter(ForecastTotalConverter.FieldType.PREMIUM)))).floatValue());
        result.setMax(Money.valueOf((Double) sum(convert(o.getPhrases(),
                new ForecastTotalConverter(ForecastTotalConverter.FieldType.MAX)))).floatValue());


        return result;
    }

}
