package ru.yandex.autotests.direct.utils;


import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

import ru.yandex.autotests.irt.testutils.RandomUtils;


/**
 * Created with IntelliJ IDEA.
 * User: omaz
 * Date: 12.11.13
 * Time: 18:30
 * To change this template use File | Settings | File Templates.
 */
public class PhraseTexts {
    private int counter = 0;
    public static Map<String, BigInteger> PHRASES = ImmutableMap.<String, BigInteger>builder()
            .put("купить iphone в рассрочку", new BigInteger("102780149"))
            .put("автомобили с пробегом", new BigInteger("247969"))
            .put("елочные игрушки", new BigInteger("124805"))
            .put("тестирование крокодилов", new BigInteger("10846985589349177493"))
            .put("нудистские пляжи", new BigInteger("349204"))
            .put("иосиф кобзон", new BigInteger("362554"))
            .put("харакири в домашних условиях", new BigInteger("12338583289501228744"))
            .put("пингвины социопаты", new BigInteger("201383148918603767"))
            .put("тестировщики директа лучшие", new BigInteger("8283100739850602093"))
            .put("превращение воды в вино", new BigInteger("9725252186185271187"))
            .put("стрижки для тараканов", new BigInteger("14969046408827805281"))
            .put("бои хомяков", new BigInteger("358285501"))
            .put("сажать картофель страусом", new BigInteger("5247299977917411836"))
            .put("летные характеристики киви", new BigInteger("4837271361917439529"))
            .put("битва на ложках", new BigInteger("11361509978598979654"))
            .put("бритье топором", new BigInteger("18390894429442771833"))
            .put("анонимные аутофобы", new BigInteger("16873492182880815160"))
            .put("гомоморфный образ группы", new BigInteger("870930016369207881"))
            .put("самоучитель русского мата", new BigInteger("3635855203148703438"))
            .put("зарядить айфон в микроволновке", new BigInteger("635540699"))
            .put("котята шредингера купить", new BigInteger("2599694652542276219"))
            .put("рязань лозохождение", new BigInteger("13260288058254609779"))
            .put("наручные атомные часы", new BigInteger("131624059"))
            .put("лабрадоры плейстоцена", new BigInteger("9060335957695041170"))
            .put("варить клейстер всей семьей", new BigInteger("5339643587959075318"))
            .put("спектрохроматография по скайпу", new BigInteger("2197586515206100634"))
            .put("козни в детском саду", new BigInteger("17458366973477117239"))
            .put("рогатка из вешалки", new BigInteger("4547715189536721796"))
            .put("липосакция КНДР срочно", new BigInteger("7094888629045455036"))
            .put("народная медицина щавель", new BigInteger("6435039480506736474"))
            .put("монстры под кроватью классификация", new BigInteger("8010855695959685111"))
            .put("отец братьев пилотов", new BigInteger("2168190295736085348"))
            .put("тунгусский планетарий", new BigInteger("13598075579628789105"))
            .put("многоразовые летчики", new BigInteger("7726865443622770229"))
            .put("экспресс-метод Анны Карениной", new BigInteger("10658076945601389412"))
            .put("ядра чистый изумруд", new BigInteger("190849455"))
            .put("однорукие бандиты", new BigInteger("8055"))
            .put("яркая котлета", new BigInteger("10410793064097046305"))
            .put("бульдозеры и болотоходы с доставкой", new BigInteger("9940732838025744827"))
            .put("продукт готовый к злоупотреблению", new BigInteger("3484736973427642872"))
            .put("кузькина мать зовет", new BigInteger("1884403924264536814"))
            .put("базар копейку любит", new BigInteger("7966017304684763771"))
            .put("тестирование виски", new BigInteger("10947944812036307085"))
            .put("однорогий заяц", new BigInteger("8646827368681712724"))
            .put("счастливый блокнот", new BigInteger("118384996"))
            .put("драники в сметане", new BigInteger("3668195857319932185"))
            .put("срочно продам волосы", new BigInteger("124805922"))
            .put("ромашковый чай", new BigInteger("1216746"))
            .put("бюро находок", new BigInteger("2125799"))
            .put("пакет с весной", new BigInteger("16051627778504819805"))
            .put("спортивные вещи", new BigInteger("12084097"))
            .put("мастер фломастер", new BigInteger("262156346"))
            .put("ништяки для грызунов", new BigInteger("5376128850296971313"))
            .put("комната на петроградке", new BigInteger("1911530209"))
            .put("потеряшка в офисе", new BigInteger("15334663696166958137"))
            .build();

    private static String[] texts = PHRASES.keySet().toArray(new String[0]);

    /*
    Метод берет фразы по порядку.
    Нужен, если необходимо, чтобы фразы не повторялись.
     */
    public String getNext() {
        if (counter >= texts.length)
            throw new DirectUtilsException("Кончились доступные тексты фраз");
        String phraseText = texts[counter];
        counter++;
        return  phraseText;
    }

    /*
    Случайная фраза из списка
     */
    public static String getRandom(){
        return texts[RandomUtils.getNextInt(texts.length)];
    }

    public static String[] getTexts(int i){
        if (i<1 && i>texts.length){
            throw new DirectUtilsException("Кончились доступные тексты фраз");
        }
        PhraseTexts phraseTexts = new PhraseTexts();
        List<String> texts = new ArrayList<>();
        for (int j=0;j<i;j++){
            texts.add(phraseTexts.getNext());
        };
        return texts.toArray(new String[0]);
    }
}
