package ru.yandex.autotests.direct.utils.beans;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * <p>Stores bean that can be named with templateName
 *
 * @param <T> Bean class
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class BeanWrapper<T> implements IBeanWrapper<T> {
    public BeanWrapper() {
    }

    public BeanWrapper(T bean, String templateName) {
        this.bean = bean;
        this.templateName = templateName;
        this.beanClassName = bean.getClass().getName();
    }

    private T bean;

    private String templateName;

    private String beanClassName;

    /**
     * Wraps a bean
     *
     * @param bean Bean to be wrapped
     * @param <T>  Bean class
     * @return Returns {@link BeanWrapper} object with {@link T} bean
     */
    public static <T> BeanWrapper<T> wrap(T bean) {
        return new BeanWrapper<T>(bean, null);
    }

    @Override
    public T getBean() {
        return bean;
    }

    public String getTemplateName() {
        return templateName;
    }

    public String getBeanClassName() {
        return beanClassName;
    }

    @Override
    public String toString() {
        return JsonUtils.toString(bean);
    }

    @Override
    public synchronized boolean equals(Object got){
        if (!(got instanceof BeanWrapper)) return false;
        BeanWrapper other = (BeanWrapper) got;
        return this.getBean().equals(other.getBean());
    }
}