package ru.yandex.autotests.direct.utils.beans;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import ru.yandex.autotests.direct.utils.DirectUtilsException;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created by chicos on 22.07.2015.
 */
public class JsonObject extends JSONObject {

    public JsonObject() {
        super();
    }

    public JsonObject(Object bean) {
        super();
        if (bean == null) {
            return;
        }
        JSONObject parsedBean;
        try {
            //если передана мапа, то возьмем ее бин
            parsedBean = (JSONObject) (new JSONParser().parse(JsonUtils.toString(
                    (ModelBeanMap.class.isAssignableFrom(bean.getClass()))?
                            (((ModelBeanMap)bean).getBean()):
                            (bean))));
        } catch (ParseException ex) {
            throw new DirectUtilsException("Не удается сформировать JsonObject для переданного объекта с типом " + bean.getClass());
        }
        this.putAll(parsedBean);
    }

    public JsonObject with(Object key, Object value) {
        super.put(key, value);
        return this;
    }
}
