package ru.yandex.autotests.direct.utils.clients.blackbox;

import java.util.Objects;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Данные о пользователе из паспорта
 *
 * @author egorovmv
 */
public class PassportUserInfo {
    private final String login;
    private final String uid;
    private final String email;
    private final String fullName;

    public PassportUserInfo(String login, String uid, String fullName, String email) {
        Objects.requireNonNull(login, "login");
        Objects.requireNonNull(uid, "uid");

        this.login = login;
        this.uid = uid;
        this.email = email != null ? email : login + "@yandex.ru";
        this.fullName = fullName != null ? fullName : login;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public String getLogin() {
        return login;
    }

    public String getUid() {
        return uid;
    }

    public String getEmail() {
        return email;
    }

    public String getFullName() {
        return fullName;
    }
}
