package ru.yandex.autotests.direct.utils.clients.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;

import ru.yandex.autotests.direct.utils.clients.tvm.TvmTicketsProvider;
import ru.yandex.autotests.direct.utils.config.TvmSecret;

class TvmCredentialsProvider implements AWSCredentialsProvider {
    private final TvmSecret tvmSecret;
    private final TvmTicketsProvider ticketsProvider;

    public TvmCredentialsProvider(TvmSecret tvmSecret) {
        this.tvmSecret = tvmSecret;
        ticketsProvider = TvmTicketsProvider.getInstance(tvmSecret);
    }

    @Override
    public AWSCredentials getCredentials() {
        return new BasicSessionCredentials(
                "TVM_V2_" + tvmSecret.getTvmClientId(),
                "unused",
                "TVM2 " + ticketsProvider.getServiceTicket(S3Helper.S3_TVM_ID_PROD));
    }

    @Override
    public void refresh() {
    }
}
