package ru.yandex.autotests.direct.utils.clients.tvm;

import ru.yandex.autotests.direct.utils.config.DirectTestTvmSecret;
import ru.yandex.autotests.direct.utils.config.QloudTvmSecret;
import ru.yandex.autotests.direct.utils.config.TvmSecret;

public class ServiceTicketProviderProxy implements ServiceTicketProvider {

    private QloudTvmSecret qloudTvmSecret = new QloudTvmSecret();

    @Override
    public String getServiceTicket(long dstClientId) {
        TvmSecret tvmSecret;
        if (qloudTvmSecret.isEnvSecretClientIdSet()) {
            tvmSecret = qloudTvmSecret;
        } else {
            tvmSecret = DirectTestTvmSecret.getInstance();
        }
        return TvmTicketsProvider.getInstance(tvmSecret).getServiceTicket(dstClientId);
    }
}
