package ru.yandex.autotests.direct.utils.config;

import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.autotests.direct.utils.DirectUtilsException;
import ru.yandex.autotests.direct.utils.converter.ListConverter;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;
import ru.yandex.qatools.properties.annotations.Use;
import ru.yandex.qatools.secrets.SecretWithKey;
import ru.yandex.qatools.secrets.SecretsLoader;

/**
 * Created by mariabye on 16.02.16.
 */
@Resource.Classpath("direct.test.run.properties")
public class DirectTestRunProperties {
    private static final String STAGE_SEPARATOR = ",";
    private static DirectTestRunProperties instance = null;
    //region general properties
    @Property("direct.stage")
    protected String directStage = "TS";
    @Property("direct.use.ipv6")
    protected boolean directUseIpv6 = true;
    //to disable limitaions use haselacast.properties hazelcast.disable = true | false
    @Property("direct.semaphore.permits")
    protected int directSemaphorePermits = 100;
    //region ba properties
    @Property("ba.stage")
    protected String baStage = null;
    //region balance properties
    @Property("balance.stage.type")
    protected String balanceStageType = "INTEGRATION";
    //endregion
    //endregion
    @Property("balance.simple.stage.type")
    protected String balanceSimpleStageType = "TESTING";
    /**
     * Использование нотификаций Баланса.
     * true - дожидаемся настоящих нотифкаций
     * false - посылаем свой NotifyOrder2
     */
    @Property("direct.use.real.notify.order")
    protected boolean directUseRealNotifyOrder = false;
    //region db properties
    @Property("direct.db.username")
    protected String directDbUserName = "autotester";
    @Property("direct.db.password")
    protected String directDbPassword = "6f8c114b58f2ce9e";
    //endregion
    //region intapi properties
    @Property("direct.intapi.stage")
    protected String directIntapiStage = null;
    @Property("direct.intapi.java.stage")
    protected String directIntapiJavaStage = null;
    @Property("direct.intapi.attempts.to.create.new.client")
    protected int directIntapiAttemptsToCreateNewClient = 2;
    @Property("direct.intapi.tvm.client_id")
    protected long directIntapiTvmClientId = 2000693;
    @Property("direct.sandbox.intapi.tvm.cleint_id")
    protected long directSandboxIntapiTvmClientId = 2000926;
    //endregion
    @Property("direct.intapi.connection.timeout.millis")
    protected int directIntapiConnectionTimeoutMillis = 450_000;
    @Property("direct.bsapi.host")
    protected String directBSapiHost = "https://bsapi-smart-ts.qart.yandex.ru:35999";
    @Property("direct.bmapi.host")
    protected String directBMapiHost = "http://bmapi-test01i.yandex.ru/fcgi-bin:80";
    @Property("geo.context.host")
    protected String geoContextHost = "http://test-geocontext.ppc.yandex.ru:16080";
    //region bs properties
    @Property("direct.transport.check.stderr")
    protected boolean directTransportCheckStderr = true;
    @Property("direct.transport.clear.queues")
    protected boolean directTransportClearQueues = false;
    @Property("direct.transport.bk.send.to.bs")
    protected boolean directTransportBkSendToBS = true;
    @Property("direct.transport.fake.bs")
    protected boolean directTransportFakeBS = true;
    @Property("direct.transport.no.auto.buggy")
    protected boolean directTransportNoAutoBuggy = true;
    @Property("direct.transport.no.logbroker")
    protected boolean directTransportNoLogbroker = false;
    @Property("direct.transport.fake.bs.host")
    protected String directTransportFakeBSHost = "http://fakebs-proxy.qart.yandex.ru/proxy/";
    @Property("direct.transport.bs.url.data")
    protected String directTransportBSUrlData = null;
    @Property("direct.transport.bs.url.prices")
    protected String directTransportBSUrlPrices = null;
    @Property("direct.transport.check.full.lb.export")
    protected boolean directTransportCheckFullLBExport = false;
    @Property("direct.transport.check.camps_only")
    protected boolean directTransportCheckCampsOnly = false;

    //endregion
    //region bs integration test properties
    @Property("yabs.audit.host")
    protected String yabsAuditHost = null;
    @Property("yabs.audit.port")
    protected Integer yabsAuditPort = null;
    @Property("yabs.audit.header.host")
    protected String yabsAuditHeaderHost = null;
    @Property("yabs.soap.host")
    protected String yabsSoapHost = null;
    @Property("yabs.collectors.path")
    protected String yabsCollectorsPath = null;
    @Property("yabs.audit.login")
    protected String yabsAuditLogin = null;
    @Property("yabs.audit.password")
    protected String yabsAuditPassword = null;
    //endregion
    //region api properties
    @Property("direct.api.stage")
    protected String directApiStage = null;
    @Property("direct.api5.reports.force.offline.mode")
    protected Boolean directApi5ReportsForceOfflineMode = false;
    @Property("direct.api5.reports.offline.mode.timeout")
    protected Integer directApi5ReportsOfflineModeTimeout = 30;
    //endregion
    @Property("direct.api.default.content.type")
    protected String directApiDefaultContentType = "JSON";
    @Property("direct.api.locale")
    protected String directApiLocale = "en";
    @Property("direct.api.sandbox.ui.stage")
    protected String directApiSandboxUIStage = "TS";
    @Property("direct.api.ignore.error.details")
    protected boolean directApiIgnoreErrorDetails = false;
    @Property("direct.api.use.db.finance.token")
    protected boolean directApiUseDbFinanceToken = false;
    @Property("direct.api.login")
    protected String directApiLogin = "at-direct-super";
    @Use(ListConverter.class)
    @Property("direct.api.ignore.detail.for.codes")
    protected List<String> directApiIgnoreDetailForCodes = null;
    //region cmd properties
    @Property("direct.cmd.stage")
    protected String directCmdStage = null;
    @Property("direct.cmd.locale")
    protected String directCmdLocale = "ru";
    @Property("direct.cmd.save_text_adgroups_in_java")
    protected boolean saveTextAdgroupsInJava = false;
    //endregion
    @Property("direct.cmd.mongo.templates.collection")
    protected String directCmdMongoTemplatesCollection = "DirectCmdTemplates";
    @Property("direct.cmd.auth.passport.host")
    protected String directCmdAuthPassportHost = "https://passport.yandex.ru/passport?mode=auth";
    @Property("direct.passport.blackbox.url")
    protected String directPassportBlackboxUrl = "http://blackbox-mimino.yandex.net/blackbox";
    @Property("direct.passport.blackbox.tvm.cleint_id")
    protected long directPassportBlackboxTvmClientId = 239L;
    @Property("direct.cmd.auth.no.captcha")
    protected boolean directCmdAuthNoCaptcha = true;
    @Property("directcmd.rule.retry.times")
    protected int directCmdRetryTimes = 0;
    @Property("directcmd.rule.deletecamp.failed")
    protected boolean directCmdDeleteCampOnFailed = true;
    @Property("directcmd.rule.deletecamp.broken")
    protected boolean directCmdDeleteCampOnBroken = true;
    @Property("directcmd.jss.validation")
    protected boolean directCmdJssValidation = false;
    //region web properties
    @Property("direct.web.mongo.templates.collection")
    protected String directWebMongoTemplatesCollection = "DirectWebTemplates45";
    @Property("direct.web.bayan.host")
    protected String directWebBayanHost = null;
    //endregion
    @Property("direct.web.super.login")
    protected String directWebSuperLogin = null;
    @Property("direct.web.webdriver.script.timeout.sec")
    protected int directWebWebdriverScriptTimeoutSec = 5;
    @Property("direct.web.webdriver.implicity.wait.timeout.sec")
    protected int directWebWebdriverImplicityWaitTimeoutSec = 10;
    @Property("direct.web.webdriver.pageload.timeout.sec")
    protected int directWebWebdriverPageloadTimeoutSec = 20;
    @Property("direct.web.local.firefox")
    protected boolean directWebLocalFirefox = false;
    //region moderation properties
    @Property("direct.moderation.stage")
    protected String directModerationStage = null;
    @Property("direct.moderation.login")
    protected String directModerationLogin = "robot-moderation-tst";
    //endregion
    @Property("direct.moderation.common.timeout")
    protected Integer directModerationCommonTimeout = 60_000;  //ms
    @Property("direct.moderation.common.timeout.pollingInterval")
    protected Integer directModerationCommonPollingInterval = 5_000; //ms
    @Property("direct.moderation.common.unload_data_to_yt")
    protected Boolean directModerationCommonUnloadDataToYt = false;
    @Property("direct.moderation.delete.created.objects")
    protected Boolean directModerationDeleteCreatedObjects = true;
    //region cocaine properties
    @Property("cocaine.app.stage")
    protected String cocaineAppStage = null;
    @Property("cocaine.app.ts.instance")
    protected int cocaineAppInstance = 8080;
    //endregion
    @Property("cocaine.app.timeout")
    protected int cocaineAppTimeout = 30;

    @Property("direct.api5.reports.backtoback.testfiles")
    protected String api5ReportsBacktobackTestfiles;

    @Property("direct.api5.reports.backtoback.allowed.write.responses.in.indefinite.storage")
    protected boolean api5ReportsBacktobackAllowedWriteResponsesInIndefiniteStorage = false;

    @Property("direct.api5.reports.backtoback.responses.in.indefinite.storage")
    protected boolean api5ReportsBacktobackResponsesInIndefiniteStorage = false;

    @Property("direct.api5.reports.backtoback.responses.directory")
    protected String api5ReportsBacktobackResponsesDirectory = null;

    @Property("direct.api5.reports.backtoback.result.directory")
    protected String api5ReportsBacktobackResultDirectory = null;

    @Property("direct.api5.reports.backtoback.compare.only.run.failed")
    protected boolean api5ReportsBacktobackCompareOnlyRunFailed = false;

    @Property("direct.api5.reports.backtoback.compare.failed.url")
    protected String api5ReportsBacktobackCompareFailedUrl = null;

    /*
        Если задано то nginx не будет роутить в java сервисы имеющие имлементацию в перле
        аналогично в Perl не будет работать проксирование Java.
     */
    @Property("direct.api5.prefer_perl_implementation")
    protected boolean api5PreferPerlImplementation = false;

    @Property("direct.tus.host")
    protected String tusHost = "tus.yandex-team.ru";

    @SecretWithKey(secret = "sec-01efxvd1kdn7m8hq41jp412xty", key = "tus_robot-irt-jenkins_token")
    private String tusToken;

    private String predefinedIntapiHost = null;

    private DirectTestRunProperties() {
        PropertyLoader.populate(this);
        SecretsLoader.populate(this);
    }

    public static DirectTestRunProperties newInstance() {
        return new DirectTestRunProperties();
    }

    public static DirectTestRunProperties getInstance() {
        if (instance == null) {
            instance = new DirectTestRunProperties();
        }
        return instance;
    }
    //endregion

    public void setDirectUseIpv6(boolean directUseIpv6) {
        this.directUseIpv6 = directUseIpv6;
    }

    public void setBalanceStageType(String balanceStageType) {
        this.balanceStageType = balanceStageType;
    }

    public void setDirectStage(String directStage) {
        this.directStage = directStage;
    }

    public void setDirectApiLocale(String directApiLocale) {
        this.directApiLocale = directApiLocale;
    }

    public void setDirectApiSandboxUIStage(String directApiSandboxUIStage) {
        this.directApiSandboxUIStage = directApiSandboxUIStage;
    }

    private String getDirectStage() {
        return directStage;
    }

    public boolean isDirectUseIpv6() {
        return directUseIpv6;
    }

    private String getDirectIntapiStage() {
        return directIntapiStage;
    }

    public String getDirectIntapiJavaStage() {
        return directIntapiJavaStage;
    }

    private String getDirectApiStage() {
        return directApiStage;
    }

    private String getDirectCmdStage() {
        return directCmdStage;
    }

    private String getBaStage() {
        return baStage;
    }

    private String getDirectModerationStage() {
        return directModerationStage;
    }

    public String getCocaineAppStage() {
        return cocaineAppStage;
    }

    public int getCocaineAppInstance() {
        return cocaineAppInstance;
    }

    public int getCocaineAppTimeout() {
        return cocaineAppTimeout;
    }

    public String getDirectHost() {
        return resolveDirectStageTypeToHost(getDirectStage());
    }

    public String getDirectIntapiHost() {
        String host = predefinedIntapiHost;
        if (host == null) {
            if (!isDefined(getDirectIntapiStage())) {
                host = resolveDirectStageTypeToHost(getDirectStage());
            } else {
                host = resolveDirectStageTypeToHost(getDirectIntapiStage());
            }
            host = injectBetaIntapiHost(host);
            host = injectTSIntapiHost(host);
        }
        return host;
    }

    public String getDirectIntapiJavaHost() {
        String host = null;
        if (!isDefined(getDirectIntapiJavaStage())) {
            return injectTSIntapiPort(getDirectIntapiHost());
        } else {
            host = resolveDirectStageTypeToHost(getDirectIntapiJavaStage());
        }
        host = injectBetaIntapiHost(host);
        host = injectTSIntapiPort(host);
        return host;
    }

    public String getDirectIntapiJavaHost(String stage) {
        String host = "https://" + resolveDirectStageTypeToHost(stage);
        host = injectBetaIntapiHost(host);
        host = injectTSIntapiHost(host);
        host = injectTSIntapiPort(host);
        return host;
    }

    private String injectBetaIntapiHost(String host) {
        if (host.matches(".*beta\\d.*") && !host.contains("intapi")) {
            return host.replaceFirst("beta\\d.", "$0intapi.");
        }
        return host;
    }

    private String injectTSIntapiHost(String host) {
        if (host.contains("test.direct.yandex.ru") && !host.contains("intapi")) {
            return host.replaceFirst("test.direct.yandex.ru", "intapi.$0");
        }
        return host;
    }

    private String injectTSIntapiPort(String host) {
        if (host.contains("test-direct.yandex.ru") && !host.matches(".*:\\d+.*")) {
            return host.replaceFirst("test-direct.yandex.ru", "$0:9443");
        }
        if (host.contains("test.direct.yandex.ru") && !host.matches(".*:\\d+.*")) {
            return host.replaceFirst("test.direct.yandex.ru", "$0:9443");
        }
        if (host.contains("intapi.test.direct.yandex.ru") && !host.matches(".*:\\d+.*")) {
            return host.replaceFirst("intapi.test.direct.yandex.ru", "$0:9443");
        }
        return host;
    }

    public String getDirectAPIHost() {
        if (!isDefined(getDirectApiStage())) {
            return resolveDirectStageTypeToHost(getDirectStage());
        } else {
            return resolveDirectStageTypeToHost(getDirectApiStage());
        }
    }

    public String getDirectSandboxInitHost() {
        if (!isDefined(getDirectApiSandboxUiStage())) {
            return resolveDirectStageTypeToHost(getDirectStage());
        } else {
            return resolveDirectStageTypeToHost(getDirectApiSandboxUiStage());
        }
    }

    public boolean isDirectAPIStageTS() {
        return (getDirectAPIHost().contains("test-direct") || getDirectAPIHost().contains("test.direct"));
    }


    public String getDirectCmdHost() {
        String result;
        if (!isDefined(getDirectCmdStage())) {
            result = resolveDirectStageTypeToHost(getDirectStage());
        } else {
            result = resolveDirectStageTypeToHost(getDirectCmdStage());
        }
        return result.replace("https://", "");
    }

    public String getBalanceStageType() {
        return balanceStageType;
    }

    public String getBAHost() {
        return resolveBaStageTypeToHost(getBaStage());
    }

    public String getModerationHost() {
        return resolveModerationStageTypeToHost(getDirectModerationStage());
    }

    public boolean isDirectModerationStageBeta() {
        return getModerationHost().contains("ppcmoddev");
    }

    public String getCocaineAppHost() {
        if (isDefined(getCocaineAppStage())) {
            return resolveCocaineStageTypeToHost(getCocaineAppStage());
        } else if (!isHost(getDirectStage())) {
            return resolveCocaineStageTypeToHost(getDirectStage());
        }
        throw new DirectUtilsException("Unknown cocaine app host.");
    }

    private boolean isDefined(String smth) {
        return (smth != null && !smth.isEmpty());
    }

    private boolean isHost(String possibleHost) {
        return possibleHost.startsWith("http");
    }

    public String getDirectAPILogin() {
        return directApiLogin;
    }

    public String getDirectAPILocale() {
        return directApiLocale;
    }

    public String getDirectCmdLocale() {
        return directCmdLocale;
    }

    public boolean isSaveTextAdgroupsInJava() {
        return saveTextAdgroupsInJava;
    }

    public String getDirectCmdMongoTemplatesCollection() {
        return directCmdMongoTemplatesCollection;
    }

    public boolean isDirectCmdAuthNoCaptcha() {
        return directCmdAuthNoCaptcha;
    }

    public void setDirectCmdAuthNoCaptcha(boolean value) {
        this.directCmdAuthNoCaptcha = value;
    }

    public String getDirectCmdAuthPassportHost() {
        return directCmdAuthPassportHost;
    }

    public void setDirectCmdAuthPassportHost(String directCmdAuthPassportHost) {
        this.directCmdAuthPassportHost = directCmdAuthPassportHost;
    }

    public String getDirectPassportBlackboxUrl() {
        return directPassportBlackboxUrl;
    }

    public long getDirectPassportBlackboxTvmClientId() {
        return directPassportBlackboxTvmClientId;
    }

    public void setDirectPassportBlackboxUrl(String directPassportBlackboxUrl) {
        this.directPassportBlackboxUrl = directPassportBlackboxUrl;
    }

    public void setDirectCmdStage(String stage) {
        this.directCmdStage = stage;
    }

    public int getDirectCmdRetryTimes() {
        return directCmdRetryTimes;
    }

    public boolean isDirectCmdDeleteCampOnFailed() {
        return directCmdDeleteCampOnFailed;
    }

    public boolean isDirectCmdDeleteCampOnBroken() {
        return directCmdDeleteCampOnBroken;
    }

    public boolean isDirectCmdJssValidation() {
        return directCmdJssValidation;
    }

    public List<String> getDirectApiIgnoreDetailForCodes() {
        return directApiIgnoreDetailForCodes;
    }

    public boolean isDirectUseRealNotifyOrder() {
        return directUseRealNotifyOrder;
    }

    public String getDirectAPISemaphoreKey() {
        return String.format("direct-%s-%s",
                getDirectAPIHost(), "api");
    }

    public String getDirectCmdSemaphoreKey() {
        return String.format("direct-%s-%s",
                getDirectAPIHost(), "cmd");
    }

    public String getDirectUISemaphoreKey() {
        return String.format("direct-%s-%s",
                getDirectAPIHost(), "ui");
    }

    public String getDirectIntapiSemaphoreKey() {
        return String.format("direct-%s-%s",
                getDirectAPIHost(), "intapi");
    }

    public String getDirectTransportSemaphoreKey() {
        return String.format("direct-%s-%s",
                getDirectAPIHost(), "bs");
    }

    public String getDirectDbUserName() {
        return directDbUserName;
    }

    public String getDirectDbPassword() {
        return directDbPassword;
    }

    public int getDirectIntapiAttemptsToCreateNewClient() {
        return directIntapiAttemptsToCreateNewClient;
    }

    public long getDirectIntapiTvmClientId() {
        return directIntapiTvmClientId;
    }

    public long getDirectSandboxIntapiTvmClientId() { return directSandboxIntapiTvmClientId; }

    public String getDirectBSapiHost() {
        return directBSapiHost;
    }

    public boolean isDirectTransportClearQueues() {
        return directTransportClearQueues;
    }

    public String getDirectTransportFakeBSHost() {
        return directTransportFakeBSHost;
    }

    public String getDirectTransportBSUrlData() {
        return directTransportBSUrlData;
    }

    public String getDirectTransportBSUrlPrices() {
        return directTransportBSUrlPrices;
    }

    public String getYabsAuditHost() {
        return yabsAuditHost;
    }

    public Integer getYabsAuditPort() {
        return yabsAuditPort;
    }

    public String getYabsAuditHeaderHost() {
        return yabsAuditHeaderHost;
    }

    public String getYabsSoapHost() {
        return yabsSoapHost;
    }

    public String getYabsCollectorsPath() {
        return yabsCollectorsPath;
    }

    public String getYabsAuditLogin() {
        return yabsAuditLogin;
    }

    public String getYabsAuditPassword() {
        return yabsAuditPassword;
    }

    public String getDirectApiDefaultContentType() {
        return directApiDefaultContentType;
    }

    public String getDirectApiLocale() {
        return directApiLocale;
    }

    public String getDirectApiSandboxUIStage() {
        return directApiSandboxUIStage;
    }

    public boolean isDirectApiIgnoreErrorDetails() {
        return directApiIgnoreErrorDetails;
    }

    public String getDirectApiLogin() {
        return directApiLogin;
    }

    public String getDirectWebMongoTemplatesCollection() {
        return directWebMongoTemplatesCollection;
    }

    public String getDirectWebBayanHost() {
        return directWebBayanHost;
    }

    public String getDirectWebSuperLogin() {
        return directWebSuperLogin;
    }

    public int getDirectWebWebdriverScriptTimeoutSec() {
        return directWebWebdriverScriptTimeoutSec;
    }

    public int getDirectWebWebdriverImplicityWaitTimeoutSec() {
        return directWebWebdriverImplicityWaitTimeoutSec;
    }

    public int getDirectWebWebdriverPageloadTimeoutSec() {
        return directWebWebdriverPageloadTimeoutSec;
    }

    public boolean isDirectWebLocalFirefox() {
        return directWebLocalFirefox;
    }

    public int getDirectSemaphorePermits() {
        return directSemaphorePermits;
    }

    public int getDirectIntapiConnectionTimeoutMillis() {
        return directIntapiConnectionTimeoutMillis;
    }

    public String getDirectBMapiHost() {
        return directBMapiHost;
    }

    public String getGeoContextHost() {
        return geoContextHost;
    }

    public boolean isDirectTransportCheckStderr() {
        return directTransportCheckStderr;
    }

    public boolean isDirectTransportBkSendToBS() {
        return directTransportBkSendToBS;
    }

    public boolean isDirectTransportFakeBS() {
        return directTransportFakeBS;
    }

    public boolean isDirectTransportNoAutoBuggy() {
        return directTransportNoAutoBuggy;
    }

    public boolean isDirectTransportNoLogbroker() {
        return directTransportNoLogbroker;
    }

    public boolean isDirectApiUseDbFinanceToken() {
        return directApiUseDbFinanceToken;
    }

    public boolean isDirectTransportCheckFullLBExport() {
        return directTransportCheckFullLBExport;
    }

    public boolean isDirectTransportCheckCampsOnly() {
        return directTransportCheckCampsOnly;
    }

    public String getDirectApiSandboxUiStage() {
        return directApiSandboxUIStage;
    }

    public String getBalanceSimpleStageType() {
        return balanceSimpleStageType;
    }

    public Boolean getDirectApi5ReportsForceOfflineMode() {
        return directApi5ReportsForceOfflineMode;
    }

    public Integer getDirectApi5ReportsOfflineModeTimeout() {
        return directApi5ReportsOfflineModeTimeout;
    }

    public String getDirectModerationLogin() {
        return directModerationLogin;
    }

    public Integer getDirectModerationCommonTimeout() {
        return directModerationCommonTimeout;
    }

    public Integer getDirectModerationCommonPollingInterval() {
        return directModerationCommonPollingInterval;
    }

    public Boolean getDirectModerationCommonUnloadDataToYt() {
        return directModerationCommonUnloadDataToYt;
    }

    public Boolean getDirectModerationDeleteCreatedObjects() {
        return directModerationDeleteCreatedObjects;
    }


    public boolean isApi5ReportsBacktobackResponsesInIndefiniteStorage() {
        return api5ReportsBacktobackResponsesInIndefiniteStorage;
    }

    public boolean isApi5ReportsBacktobackAllowedWriteResponsesInIndefiniteStorage() {
        return api5ReportsBacktobackAllowedWriteResponsesInIndefiniteStorage;
    }

    public String getApi5ReportsBacktobackTestfiles() {
        return api5ReportsBacktobackTestfiles;
    }

    public String getApi5ReportsBacktobackResponsesDirectory() {
        return api5ReportsBacktobackResponsesDirectory;
    }

    public String getApi5ReportsBacktobackResultDirectory() {
        return api5ReportsBacktobackResultDirectory;
    }

    public boolean isApi5ReportsBacktobackCompareOnlyRunFailed() {
        return api5ReportsBacktobackCompareOnlyRunFailed;
    }

    public String getApi5ReportsBacktobackCompareFailedUrl() {
        return api5ReportsBacktobackCompareFailedUrl;
    }

    public boolean getApi5PreferPerlImplementation() { return api5PreferPerlImplementation; }

    public String getTusHost() {
        return tusHost;
    }

    public String getTusToken() {
        return tusToken;
    }

    public Integer getPpcDevNumber(Integer beta) {
        Integer ppcDevNumber = null;
        if (beta != null) {
            return beta / 1000 - 7;
        }
        return ppcDevNumber;
    }

    public String resolveDirectStageTypeToHost(String stageType) {
        if (stageType == null || stageType.isEmpty()) {
            throw new DirectUtilsException("Undefined direct.stage");
        }
        String stage;
        if (stageType.contains(STAGE_SEPARATOR)) {
            String[] stages = stageType.split(STAGE_SEPARATOR);
            int stageNum = new Random().nextInt(stages.length);
            stage = stages[stageNum];
        } else {
            stage = stageType;
        }
        return toDirectUrl(stage);
    }

    private String toDirectUrl(String stageType) {
        if (stageType.equalsIgnoreCase(StageType.TS.toString())) {
            return (isDirectUseIpv6()) ?
                    StageType.TS_IPv6.host() : StageType.TS.host();
        } else if (stageType.equalsIgnoreCase(StageType.TS2.toString())) {
            return (isDirectUseIpv6()) ?
                    StageType.TS2_IPv6.host() : StageType.TS2.host();
        } else if (stageType.equalsIgnoreCase(StageType.NEWTS.toString())) {
            return (isDirectUseIpv6()) ?
                    StageType.NEWTS_IPv6.host() : StageType.NEWTS.host();
        } else if (stageType.equalsIgnoreCase(StageType.PRODUCTION.toString())) {
            return StageType.PRODUCTION.toString();
        } else if (stageType.equalsIgnoreCase(StageType.SANDBOX.toString())) {
            return StageType.SANDBOX.host();
        } else if (stageType.equalsIgnoreCase(StageType.SANDBOX_TS.toString())) {
            return StageType.SANDBOX_TS.host();
        } else if (stageType.equalsIgnoreCase(StageType.SANDBOX_TS2.toString())) {
            return StageType.SANDBOX_TS2.host();
        } else if (stageType.matches("^BETA(\\d)$")) {
            Matcher matcher = Pattern.compile("^BETA(\\d)$").matcher(stageType);
            if (matcher.find()) {
                int betaNumber = Integer.parseInt(matcher.group(1));
                String host = StageType.BETA_MAIN.host();
                return String.format(host, betaNumber);
            } else {
                throw new DirectUtilsException("Unknown stage format:" + stageType);
            }
        } else if (stageType.matches("^(\\d){4,5}$")) {
            int betaPort = Integer.parseInt(stageType);
            String host = StageType.BETA.host();
            return String.format(host, betaPort, getPpcDevNumber(betaPort));
        } else if (!stageType.isEmpty()) {
            return stageType;
        } else {
            throw new DirectUtilsException("Unknown direct.stage format:" + stageType);
        }
    }

    public String resolveModerationStageTypeToHost(String stageType) {
        if (stageType != null && !stageType.isEmpty()) {
            if (stageType.equalsIgnoreCase(StageType.TS.toString()) || stageType.equalsIgnoreCase(StageType.NEWTS.toString())) {
                return StageType.MODERATION_TS.host();
            } else if (stageType.equalsIgnoreCase(StageType.TS2.toString())) {
                return StageType.MODERATION_TS2.host();
            } else if (stageType.matches("^(\\d){4}$")) {
                int betaPort = Integer.parseInt(stageType);
                return String.format(StageType.MODERATION_BETA.host(),
                        betaPort, getPpcDevNumber(betaPort));
            } else if (!stageType.isEmpty()) {
                return stageType;
            } else {
                throw new DirectUtilsException("Unknown moderation.stage format:" + stageType);
            }
        }
        throw new DirectUtilsException("Undefined moderation.stage");
    }

    public String resolveBaStageTypeToHost(String stageType) {
        if (stageType != null && !stageType.isEmpty()) {
            if (stageType.equalsIgnoreCase(StageType.TS.toString()) || stageType.equalsIgnoreCase(StageType.NEWTS.toString())) {
                return (isDirectUseIpv6()) ?
                        StageType.BA_TS_IPv6.host() : StageType.BA_TS.host();
            } else if (stageType.equalsIgnoreCase(StageType.TS2.toString())) {
                return (isDirectUseIpv6()) ?
                        StageType.BA_TS2_IPv6.host() : StageType.BA_TS2.host();
            } else if (stageType.matches("^BETA(\\d)$")) {
                Matcher matcher = Pattern.compile("^BETA(\\d)$").matcher(stageType);
                if (matcher.find()) {
                    int betaNumber = Integer.parseInt(matcher.group(1));
                    String host = (isDirectUseIpv6()) ?
                            StageType.BA_BETA_MAIN_IPv6.host() : StageType.BA_BETA_MAIN.host();
                    return String.format(host, betaNumber);
                } else {
                    throw new DirectUtilsException("Unknown stage format:" + stageType);
                }
            } else if (stageType.matches("^(\\d){4,5}$")) {
                int betaPort = Integer.parseInt(stageType);
                String host = (isDirectUseIpv6()) ?
                        StageType.BA_BETA_IPv6.host() : StageType.BA_BETA.host();
                return String.format(host, betaPort, getPpcDevNumber(betaPort));
            } else if (!stageType.isEmpty()) {
                return stageType;
            } else {
                throw new DirectUtilsException("Unknown ba.stage format:" + stageType);
            }
        }
        throw new DirectUtilsException("Undefined ba.stage");

    }

    public String resolveCocaineStageTypeToHost(String stageType) {
        if (stageType != null && !stageType.isEmpty()) {
            if (stageType.equalsIgnoreCase(StageType.TS.toString()) || stageType.equalsIgnoreCase(StageType.NEWTS.toString())) {
                return StageType.COCAINE_APP_TS.host();
            } else if (stageType.equalsIgnoreCase(StageType.TS2.toString())) {
                return StageType.COCAINE_APP_TS2.host();
            } else if (stageType.matches("^BETA(\\d)$")) {
                return String.format(StageType.COCAINE_APP_BETA.host(), 6);
            } else if (stageType.matches("^(\\d){4,5}$")) {
                return String.format(StageType.COCAINE_APP_BETA.host(), getPpcDevNumber(Integer.parseInt(stageType)));
            } else if (!stageType.isEmpty()) {
                return stageType;
            } else {
                throw new DirectUtilsException("Unknown cocaine.app.stage format:" + stageType);
            }
        }
        throw new DirectUtilsException("Undefined cocaine.app.stage");
    }

    public DirectTestRunProperties withDirectIntapiStage(String directIntapiStage) {
        this.directIntapiStage = directIntapiStage;
        return this;
    }

    public DirectTestRunProperties withPredefinedIntapiHost(String predefinedIntapiHost) {
        this.predefinedIntapiHost = predefinedIntapiHost;
        return this;
    }

    public DirectTestRunProperties withDirectStage(String directStage) {
        this.directStage = directStage;
        return this;
    }

    protected enum StageType {
        TS("https://test-direct.yandex.ru"),
        TS_IPv6("https://test.direct.yandex.ru"),
        TS2("https://test2-direct.yandex.ru"),
        TS2_IPv6("https://ipv6.test2-direct.yandex.ru"),
        NEWTS("https://test.direct.yandex.ru"),
        NEWTS_IPv6("https://ipv6.test.direct.yandex.ru"),
        BETA("https://%s.beta%s.direct.yandex.ru"),
        BETA_MAIN("https://beta%s.direct.yandex.ru"),
        BA_TS("https://test-ba.yandex.ru"),
        BA_TS2("https://test2-ba.yandex.ru"),
        BA_BETA("https://%s.beta%s.ba.yandex.ru"),
        BA_BETA_MAIN("https://beta%s.ba.yandex.ru"),
        BA_TS_IPv6("https://ipv6.test-ba.yandex.ru"),
        BA_TS2_IPv6("https://ipv6.test2-ba.yandex.ru"),
        BA_BETA_IPv6("https://%s.ipv6-beta%s.ba.yandex.ru"),
        BA_BETA_MAIN_IPv6("https://ipv6-beta%s.ba.yandex.ru"),
        MODERATION_TS("https://direct-mod-test.yandex-team.ru"),
        MODERATION_TS2("https://direct-mod-test2.yandex-team.ru"),
        MODERATION_BETA("https://%d.ppcmoddev%d.yandex-team.ru"),
        SANDBOX("https://api-sandbox.direct.yandex.ru"),
        SANDBOX_TS("https://ppctest-sandbox-ts.ppc.yandex.ru"),
        SANDBOX_TS2("https://ppctest-sandbox-ts.ppc.yandex.ru"),
        PRODUCTION("https://direct.yandex.ru"),
        COCAINE_APP_TS("ppctest-cloud2-front.yandex.ru"),
        COCAINE_APP_TS2("ppctest-cloud2-front.yandex.ru"),
        COCAINE_APP_BETA("ppcdev%s.yandex.ru");

        private String host;

        StageType(String host) {
            this.host = host;
        }

        public String host() {
            return host;
        }
    }
}
