package ru.yandex.autotests.direct.utils.config;

import com.google.common.base.Preconditions;

import ru.yandex.qatools.secrets.SecretWithKey;
import ru.yandex.qatools.secrets.SecretsLoader;

public class DirectTestTvmSecret extends TvmSecret {
    private static final String SECRET_ID = "sec-01d0stq99qaq3t80e4732ctv2x";

    private static DirectTestTvmSecret instance;

    @SecretWithKey(secret = SECRET_ID, key = KEY_SECRET)
    private String tvmSecret;

    @SecretWithKey(secret = SECRET_ID, key = KEY_ID)
    private String tvmClientId;

    private DirectTestTvmSecret() {
        SecretsLoader.populate(this);
        Preconditions.checkState(tvmSecret != null && tvmClientId != null,
                "Unable to obtain TVM credentials from the Vault, check if your token is valid");
    }

    public static DirectTestTvmSecret getInstance() {
        if (instance == null) {
            instance = new DirectTestTvmSecret();
        }
        return instance;
    }

    public String getTvmSecret() {
        return tvmSecret;
    }

    public String getTvmClientId() {
        return tvmClientId;
    }
}
