package ru.yandex.autotests.direct.utils.config;

import ru.yandex.qatools.secrets.SecretWithKey;
import ru.yandex.qatools.secrets.SecretsLoader;

public class ModerateTestTvmSecret extends TvmSecret {
    private static final String SECRET_ID = "sec-01d1r613j3br78qx8vrcfrry3g";

    private static ModerateTestTvmSecret instance;

    @SecretWithKey(secret = SECRET_ID, key = KEY_SECRET)
    private String tvmSecret;

    @SecretWithKey(secret = SECRET_ID, key = KEY_ID)
    private String tvmClientId;

    private ModerateTestTvmSecret() {
        SecretsLoader.populate(this);
    }

    public static ModerateTestTvmSecret getInstance() {
        if (instance == null) {
            instance = new ModerateTestTvmSecret();
        }
        return instance;
    }

    public String getTvmSecret() {
        return tvmSecret;
    }

    public String getTvmClientId() {
        return tvmClientId;
    }
}
