package ru.yandex.autotests.direct.utils.config;


/**
 * Используется для TVM в Рукояточнике (https://direct-handles.qart.yandex-team.ru/)
 * секрет и ClientID берем из переменных окружения
 */
public class QloudTvmSecret extends TvmSecret {

    private static final String QLOUD_TVM_SECRET_NAME = "QLOUD_TVM_SECRET";
    private static final String QLOUD_TVM_SELF_ID_NAME = "QLOUD_TVM_SELF_ID";

    @Override
    public String getTvmSecret() {
        return System.getenv(QLOUD_TVM_SECRET_NAME);
    }

    @Override
    public String getTvmClientId() {
        return System.getenv(QLOUD_TVM_SELF_ID_NAME);
    }

    public boolean isEnvSecretClientIdSet() {
        if (getTvmSecret() != null && getTvmClientId() != null) {
            return true;
        } else {
            return false;
        }
    }
}
