package ru.yandex.autotests.direct.utils.config;


import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 15.05.14.
 */
@Deprecated
public class StageSemaphore {

    private static SemaphoreProperties properties;
    private static LogSteps log = LogSteps.getLogger(StageSemaphore.class);

    /**
     * @param stageType Stage to be used to get preset limits on simultaneous test execution
     * @param betaPort  beta port, e.x. 8994
     * @return
     */
    public static SemaphoreRule getSemaphore(StageType stageType, Integer betaPort) {
        if (stageType == null) {
            throw new IllegalArgumentException("Parameter stageType for SemaphoreRule should not be null");
        }
        if (properties == null) {
            properties = new SemaphoreProperties();
        }

        //workaround to limit BETA_PRESICE + BETA1. It's better to remove BETA_PRESICE totally
        String stageName = stageType.name();
        if (stageName.equals(StageType.BETA_PRECISE.name())) {
            stageName = StageType.BETA1.name();
        }
        String betaPortName = (betaPort == null) ? ("") : ("-" + betaPort.toString());
        Integer permits = (Integer) ReflectionUtils.invokeGetter(properties, "Permits" + stageName);

        String appType = properties.getAppType();

        String ruleKey = "direct-"
                + appType + "-"
                + stageName
                + betaPortName + "-"
                + permits;
        log.info("Semaphore rule key: " + ruleKey);
        return (permits > 0) ? new SemaphoreRule(ruleKey, permits) : null;
    }

    /**
     * Костыль для старого проекта, на время пока переносим из него тесты
     * На релизе он всегда движется в общем потоке,
     * на всех остальных средах у него свой поток движения
     * Старый проект отключен
     *
     * @param baseURL api URL for old project
     * @return
     */
    public static SemaphoreRule getSemaphore(String baseURL) {
        /*if (baseURL == null) {
            throw new IllegalArgumentException("Parameter stageType for SemaphoreRule should not be null");
        }
        if (properties == null) {
            properties = new SemaphoreProperties();
        }

        String stageName = baseURL.contains("test-direct.yandex.ru") ? "TC" : "OLD";
        Integer permits = (Integer) ReflectionUtils.invokeGetter(properties, "Permits" + stageName);

        String ruleKey = "direct-api-"
                + stageName
                + "-"
                + permits;
        log.info("Semaphore rule key: " + ruleKey);
        return new SemaphoreRule(ruleKey, permits);*/
        return null;
    }
}
