package ru.yandex.autotests.direct.utils.config;

/**
 * User: mariabye
 * Date: 21.03.13
 * <p>
 * Known stage types
 */
@Deprecated
public enum StageType {
    TC("test-direct.yandex.ru", 100, 14443),
    TC2("test2-direct.yandex.ru", 250, 14443),
    TC2IPV6("ppctest-ts2-front.ppc.yandex.ru", 250, 14443),
    BETA("%s.beta%s.direct.yandex.ru", 80, 14443),
    BETA1("%s.beta1.direct.yandex.ru", 80, 14443),
    BETA2("%s.beta2.direct.yandex.ru", 80, 14443),
    BETA3("%s.beta3.direct.yandex.ru", 80, 14443),
    BETA4("%s.beta4.direct.yandex.ru", 80, 14443),
    BETA5("%s.beta5.direct.yandex.ru", 80, 14443),
    BETA6("%s.beta6.direct.yandex.ru", 80, 14443),
    BETA_T1("beta1.direct.yandex.ru", 80, 14443),
    BETA_T2("beta2.direct.yandex.ru", 80, 14443),
    BETA_T4("beta4.direct.yandex.ru", 80, 14443),
    BA("%s.beta%s.ba.yandex.ru", 80, 14443),
    BA1("%s.beta1.ba.yandex.ru", 80, 14443),
    BA2("%s.beta2.ba.yandex.ru", 80, 14443),
    BA3("%s.beta3.ba.yandex.ru", 80, 14443),
    BA4("%s.beta4.ba.yandex.ru", 80, 14443),
    BA5("%s.beta5.ba.yandex.ru", 80, 14443),
    BA6("%s.beta6.ba.yandex.ru", 80, 14443),
    BA_T1("beta1.ba.yandex.ru", 80, 14443),
    BA_T2("beta2.ba.yandex.ru", 80, 14443),
    BA_T3("beta3.ba.yandex.ru", 80, 14443),
    BA_T4("beta4.ba.yandex.ru", 80, 14443),
    BA_T5("beta5.ba.yandex.ru", 80, 14443),
    BA_T6("beta6.ba.yandex.ru", 80, 14443),
    BETA_PRECISE("%s.beta-precise.direct.yandex.ru", 80, 14443),
    TRUNK("%s.beta1.direct.yandex.ru", 150, 14443),
    SANDBOX_TC("ppctest-sandbox1-front.ppc.yandex.ru", 70, 15443),
    SANDBOX_TC2("ppctest-sandbox2-front.ppc.yandex.ru", 70, 15443),
    PRED_PRODUCTION("11003.beta4.direct.yandex.ru", 70, 14443),
    PRODUCTION("api.direct.yandex.ru", 70),
    PRODUCTION_SOAP("soap.direct.yandex.ru", 70),
    SANDBOX("api-sandbox.direct.yandex.ru", 70),
    PRODUCTION_UI("direct.yandex.ru", 70),
    GEOCONTEXT_TC("test-geocontext.ppc.yandex.ru",80, 16080),
    BMAPI_TEST("bmapi-test01i.yandex.ru/fcgi-bin", 80);

    private String host;
    private Integer limit;
    private Integer port = null;

    StageType(String host, int limit) {
        this.host = host;
        this.limit = limit;
    }

    StageType(String host, int limit, int port) {
        this.host = host;
        this.port = port;
        this.limit = limit;
    }

    public String url() {
        return host;
    }

    public Integer port() {
        return port;
    }

    /**
     * @return Limit for simultaneously run test classes allowed for specified stage
     */
    public Integer limit() {
        return limit;
    }


    public String url(Integer beta) {
        Integer ppcDevNumber = getPpcDevNumber(beta);
        if (beta != null && ppcDevNumber !=null) {
            return String.format(StageType.BETA.url(), beta, ppcDevNumber);
        } else {
            return url();
        }
    }

    public Integer getPpcDevNumber(Integer beta) {
        Integer ppcDevNumber = null;
        if (beta !=null) {
            if (beta >= 8000 && beta < 9000) {
                ppcDevNumber = 1;
            } else if (beta >= 9000 && beta < 10000) {
                ppcDevNumber = 2;
            } else if (beta >= 10000 && beta < 11000) {
                ppcDevNumber = 3;
            } else if (beta >= 11000 && beta < 12000) {
                ppcDevNumber = 4;
            } else if (beta >= 12000 && beta < 13000) {
                ppcDevNumber = 5;
            } else if (beta >= 13000 && beta < 14000) {
                ppcDevNumber = 6;
            }
        }
        return ppcDevNumber;
    }
}
