package ru.yandex.autotests.direct.utils.converter;

import java.math.RoundingMode;

import ch.lambdaj.function.convert.Converter;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.common.api45mng.BannerPhraseInfo;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 29.12.13
 * Time: 22:40
 * To change this template use File | Settings | File Templates.
 */
public class BannerPhraseInfoConverter implements Converter<BannerPhraseInfo, BannerPhraseInfo> {
    private Currency currency;
    private double currencyRate;

    public BannerPhraseInfoConverter(Currency currency, double currencyRate) {
        this.currency = currency;
        this.currencyRate = currencyRate;
    }

    @Override
    public BannerPhraseInfo convert(BannerPhraseInfo o) {
        Money min = Money.valueOf(o.getMin(), Currency.RUB)
                .multiply(currencyRate).convert(Currency.YND_FIXED).setScale(2, RoundingMode.HALF_UP);
        Money max = Money.valueOf(o.getMax(), Currency.RUB)
                .multiply(currencyRate).convert(Currency.YND_FIXED).setScale(2, RoundingMode.HALF_UP);
        Money premiumMin = Money.valueOf(o.getPremiumMin(), Currency.RUB)
                .multiply(currencyRate).convert(Currency.YND_FIXED).setScale(2, RoundingMode.HALF_UP);
        Money premiumMax = Money.valueOf(o.getPremiumMax(), Currency.RUB)
                .multiply(currencyRate).convert(Currency.YND_FIXED).setScale(2, RoundingMode.HALF_UP);
        o.setMin(min.floatValue());
        o.setMax(max.floatValue());
        o.setPremiumMin(premiumMin.floatValue());
        o.setPremiumMax(premiumMax.floatValue());
        o.setCurrency(null);
        return o;
    }
}
