package ru.yandex.autotests.direct.utils.converter;

import java.math.RoundingMode;

import ch.lambdaj.function.convert.Converter;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.common.api45.BannersStatItem;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 25.12.13
 * Time: 20:58
 * To change this template use File | Settings | File Templates.
 */
public class BannerStatItemConverter implements Converter<BannersStatItem, BannersStatItem> {
    private Currency currency;
    private boolean includeVAT;
    private boolean includeDiscount;
    private Money discount;
    private Double oldCurrencyRate;


    public BannerStatItemConverter(Currency currency, String includeVAT, String includeDiscount, Money discount) {
        this(currency, includeVAT, includeDiscount, discount, null);
    }

    public BannerStatItemConverter(
            Currency currency, String includeVAT, String includeDiscount, Money discount, Double oldCurrencyRate) {
        this.currency = currency;
        this.includeVAT = includeVAT.equals("Yes");
        this.includeDiscount = includeDiscount.equals("Yes");
        this.discount = discount;
        this.oldCurrencyRate = oldCurrencyRate;
    }

    @Override
    public BannersStatItem convert(BannersStatItem o) {
        Money sum = Money.valueOf(o.getSum(), currency)
                .convert(Currency.YND_FIXED, oldCurrencyRate).addVAT();
        Money sumSearch = Money.valueOf(o.getSumSearch(), currency)
                .convert(Currency.YND_FIXED, oldCurrencyRate).addVAT();
        Money sumContext = Money.valueOf(o.getSumContext(), currency)
                .convert(Currency.YND_FIXED, oldCurrencyRate).addVAT();
        if (includeVAT || (currency == null)) {
            sum = sum.subtractVAT(currency);
            sumSearch = sumSearch.subtractVAT(currency);
            sumContext = sumContext.subtractVAT(currency);
        }
        if (includeDiscount && (currency != null)) {
            sum = sum.withDiscount(discount.doubleValue());
            sumSearch = sumSearch.withDiscount(discount.doubleValue());
            sumContext = sumContext.withDiscount(discount.doubleValue());
        }
        o.setSum(sum.setScale(2, RoundingMode.HALF_UP).floatValue());
        o.setSumSearch(sumSearch.setScale(2, RoundingMode.HALF_UP).floatValue());
        o.setSumContext(sumContext.setScale(2, RoundingMode.HALF_UP).floatValue());
        return o;
    }
}
