package ru.yandex.autotests.direct.utils.converter;

import ch.lambdaj.function.convert.Converter;
import org.apache.commons.beanutils.BeanMap;
import ru.yandex.autotests.direct.utils.ReflectionUtils;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 02.12.13
 * Time: 17:10
 * To change this template use File | Settings | File Templates.
 */
public class BeanToBeanMapConverter<U extends BeanMap> implements Converter<Object, U> {
    private final Class<U> clazz;

    public BeanToBeanMapConverter(Class<U> clazz) {
        this.clazz = clazz;
    }

    @Override
    public  U convert(Object o) {
        return (U) ReflectionUtils.getMapInstance(clazz, o);
    }
}
