package ru.yandex.autotests.direct.utils.converter;

import org.apache.commons.beanutils.Converter;
import ru.yandex.autotests.direct.utils.DirectUtilsException;

/**
 * User: mariabye
 * Date: 26.06.13
 */
public class BetaPortConverter implements Converter {
    @Override
    public Object convert(Class aClass, Object o) {
        String[] property = o.toString().split(":");
        if (property.length == 2) {
            try {
                return Integer.parseInt(property[1]);
            } catch (Exception e) {
                throw new DirectUtilsException("Для stageType = Beta требуется указывать порт беты. " +
                        "Например, api.stageType = BETA1:8999", e);
            }
        }
        return null;
    }
}
