package ru.yandex.autotests.direct.utils.converter;

import ch.lambdaj.function.convert.Converter;
import ru.yandex.autotests.direct.utils.DirectUtilsException;
import ru.yandex.autotests.direct.utils.ReflectionUtils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Created by chicos on 06.10.14.
 */
public class EnumToStringValueConverter implements Converter<Enum, String> {

    @Override
    public String convert(Enum o) {
        String methodName = "value";
        if (o == null){
            throw new DirectUtilsException("Элемент Enum для конвертации не должен быть null");
        }
        try{
            Method method = ReflectionUtils.findMethodByName(o.getClass().getDeclaredMethods(), methodName);
            return method.invoke(o).toString();
        } catch (NoSuchMethodException e) {
            throw new DirectUtilsException(String.format("Конвертация Enum %s - отсутствует метод %s", o.getClass().getSimpleName(), methodName), e);
        } catch (InvocationTargetException e) {
            throw new DirectUtilsException(String.format("Конвертация Enum %s - ошибка метода %s ", o.getClass().getSimpleName(), methodName), e);
        } catch (IllegalAccessException e) {
            throw new DirectUtilsException(String.format("Конвертация Enum %s - ошибка доступа к методу %s ", o.getClass().getSimpleName(), methodName), e);
        }
    }
}
