package ru.yandex.autotests.direct.utils.converter;

import ch.lambdaj.function.convert.Converter;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.common.api45mng.BannerPhraseInfo;

public class ForecastTotalConverter implements Converter<BannerPhraseInfo, Double> {
    private final FieldType fieldType;

    public enum FieldType {
        MIN,
        PREMIUM,
        MAX
    }

    public ForecastTotalConverter(FieldType fieldType) {
        this.fieldType = fieldType;

    }

    @Override
    public Double convert(BannerPhraseInfo from) {
        if (fieldType.equals(FieldType.MIN)) {
            return Money.valueOf(from.getMin()).doubleValue()*from.getClicks();
        } else if (fieldType.equals(FieldType.PREMIUM)) {
            return Money.valueOf(from.getPremiumMin()).doubleValue()* from.getPremiumClicks();
        } else {
            return Money.valueOf(from.getMax()).doubleValue() * from.getFirstPlaceClicks();
        }
    }
}
