package ru.yandex.autotests.direct.utils.converter;

import org.apache.commons.beanutils.Converter;
import ru.yandex.autotests.direct.utils.DirectUtilsException;

import java.util.LinkedList;
import java.util.List;

public class LongListConverter implements Converter {

    @Override
    public Object convert(Class aClass, Object o) {
        if (o == null) {
            return null;
        }

        String campaignsListStr = o.toString();
        try {
            List<Long> result = new LinkedList<>();
            for (String campaignIdStr : campaignsListStr.split(",")) {
                result.add(Long.valueOf(campaignIdStr.trim()));
            }
            return result;
        } catch (Exception e) {
            throw new DirectUtilsException("неправильно задан параметр: " +
                    campaignsListStr + ", список чисел должен быть задан в формате xxx,yyy,zzz");
        }
    }
}
