package ru.yandex.autotests.direct.utils.converter;

import ch.lambdaj.function.convert.Converter;
import org.joda.time.DateTime;
import ru.yandex.autotests.directapi.common.api45.BannersStatItem;
import ru.yandex.autotests.directapi.objecthelpers.uiclient.data.Phrase;
import ru.yandex.autotests.directapi.objecthelpers.uiclient.data.PhrasesDict;
import ru.yandex.autotests.directapi.objecthelpers.uiclient.data.Row;

import static ch.lambdaj.Lambda.*;
import static org.hamcrest.CoreMatchers.equalTo;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 17.12.13
 * Time: 12:46
 * To change this template use File | Settings | File Templates.
 */
public class ReportRowToBannersStatItemConverter implements Converter<Row, BannersStatItem> {

    private final PhrasesDict[] dictionary;

    public ReportRowToBannersStatItemConverter(PhrasesDict[] dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public BannersStatItem convert(Row row) {
        BannersStatItem bannersStatItem = new BannersStatItem();

        bannersStatItem.setBannerID(Long.valueOf(row.getBannerID()));

        if (row.getPhraseID() != null && row.getPhraseID().equals("1")) {
            bannersStatItem.setPhraseID(null);
            bannersStatItem.setPhrase("Automatically-added phrases");
        } else if (row.getPhraseID() != null) {
            bannersStatItem.setPhraseID(Long.valueOf(row.getPhrase_id()));
            bannersStatItem.setPhrase(
                    ((Phrase) selectFirst(flatten(extract(dictionary, on(PhrasesDict.class).getPhrase())),
                            having(on(Phrase.class).getPhraseID(), equalTo(row.getPhraseID()))))
                            .getValue()
            );
        } else if (row.getDictID() != null) {
            if (row.getRetargetingID()!=null){
                bannersStatItem.setRetargetingID(Integer.valueOf(row.getRetargetingID()));
            }
            bannersStatItem.setPhrase(
                    ((Phrase) selectFirst(flatten(extract(dictionary, on(PhrasesDict.class).getPhrase())),
                            having(on(Phrase.class).getDictID(), equalTo(Integer.parseInt(row.getDictID())))))
                            .getValue().replace("ретаргетинг", "retargeting")
            );
        } else if (row.getRubricID() != null) {
            bannersStatItem.setRubricID(Integer.valueOf(row.getRubricID()));
            bannersStatItem.setPhrase(
                    ((Phrase) selectFirst(flatten(extract(dictionary, on(PhrasesDict.class).getPhrase())),
                            having(on(Phrase.class).getPhraseID(), equalTo(Integer.parseInt(row.getRubricID())))))
                            .getValue()
                            .replace("Бизнес / Финансы", "Business / Finances")//hack CreateNewReport returns cyrillic??
            );
        }

        if (row.getStatDate() != null) {
            bannersStatItem.setStatDate(DateTime.parse(row.getStatDate().toString()).toDate());
        }

        bannersStatItem.setClicks(row.getClicks());
        bannersStatItem.setShows(row.getShows());
        bannersStatItem.setSum(row.getSum());

        bannersStatItem.setClicksSearch(row.getClicks_search());
        bannersStatItem.setShowsSearch(row.getShows_search());
        bannersStatItem.setSumSearch(row.getSum_search());

        bannersStatItem.setClicksContext(row.getClicks_context());
        bannersStatItem.setShowsContext(row.getShows_context());
        bannersStatItem.setSumContext(row.getSum_context());

        bannersStatItem.setDeviceType(row.getDevice_type());

        bannersStatItem.setStatType(row.getStat_type());
        return bannersStatItem;
    }
}
