package ru.yandex.autotests.direct.utils.converter;

import ch.lambdaj.function.convert.Converter;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.common.api45.BannersStatItem;
import ru.yandex.autotests.directapi.common.api45.StatItem;
import ru.yandex.autotests.direct.utils.money.Currency;

import java.math.RoundingMode;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 25.12.13
 * Time: 21:19
 * To change this template use File | Settings | File Templates.
 */
public class StatItemConverter implements Converter<StatItem, StatItem> {
    private Currency currency;
    private boolean includeVAT;
    private boolean includeDiscount;
    private Money discount;
    private Double oldCurrencyRate;


    public StatItemConverter(Currency currency, String includeVAT, String includeDiscount, Money discount) {
        this(currency, includeVAT, includeDiscount, discount, null);
    }

    public StatItemConverter(
            Currency currency, String includeVAT, String includeDiscount, Money discount, Double oldCurrencyRate) {
        this.currency = currency;
        this.includeVAT = includeVAT.equals("Yes");
        this.includeDiscount = includeDiscount.equals("Yes");
        this.discount = discount;
        this.oldCurrencyRate = oldCurrencyRate;
    }

    @Override
    public StatItem convert(StatItem o) {
        Money sumSearch = Money.valueOf(o.getSumSearch(), currency)
                .convert(Currency.YND_FIXED, oldCurrencyRate).addVAT();
        Money sumContext = Money.valueOf(o.getSumContext(), currency)
                .convert(Currency.YND_FIXED, oldCurrencyRate).addVAT();
        Money goalCostSearch = Money.valueOf(0f);
        if (o.getGoalCostSearch() != null) {
            goalCostSearch = Money.valueOf(o.getGoalCostSearch(), currency)
                    .convert(Currency.YND_FIXED, oldCurrencyRate).addVAT();
        }
        if (includeVAT || (currency == null)) {
            sumSearch = sumSearch.subtractVAT(currency);
            sumContext = sumContext.subtractVAT(currency);
            goalCostSearch = goalCostSearch.subtractVAT(currency);
        }
        if (includeDiscount && (currency != null)) {
            sumSearch = sumSearch.withDiscount(discount.doubleValue());
            sumContext = sumContext.withDiscount(discount.doubleValue());
            goalCostSearch = goalCostSearch.withDiscount(discount.doubleValue());
        }
        o.setSumSearch(sumSearch.setScale(2, RoundingMode.HALF_UP).floatValue());
        o.setSumContext(sumContext.setScale(2, RoundingMode.HALF_UP).floatValue());
        if (o.getGoalCostSearch() != null) {
            o.setGoalCostSearch(goalCostSearch.setScale(2, RoundingMode.HALF_UP).floatValue());
        }
        return o;
    }
}
