package ru.yandex.autotests.direct.utils.date;
        
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;

import java.sql.Timestamp;

public class DBTimeConverter {

    public static DateTime dbTimeToJoda(String dbTime) {
        return new DateTime(dbTime.replace(" ", "T"));
    }

    public static String jodaTimeToDb(DateTime dateTime) {
        return DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.S").print(dateTime);
    }

    public static Timestamp jodaToSql(DateTime dateTime) {
        return new Timestamp(dateTime.getMillis());
    }

    public static DateTime sqlToJoda(Timestamp timestamp) {
        return sqlToJoda(timestamp, DateTimeZone.getDefault());
    }

    public static DateTime sqlToJoda(Timestamp timestamp, DateTimeZone zone) {
        return new DateTime(timestamp, zone);
    }
}