package ru.yandex.autotests.direct.utils.matchers;

import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class BeanCompareStrategy {
    private Map<String, Matcher> map = new HashMap<>();

    public BeanCompareStrategy putFieldMatcher(String fieldName, Matcher matcher){
        map.put(fieldName, matcher);
        return this;
    }

    public Matcher getFieldMatcher(String fieldName){
        return map.get(fieldName);
    }

    protected Set<String> getFieldNames(){
        return map.keySet();
    }

    @Override
    public String toString(){
        if(map.keySet().size() == 0) {
            return "Точное стравнение полей";
        }
        return "Кастомное сравнение для полей: " + StringUtils.join(map.keySet(), ",");
    }
}

