package ru.yandex.autotests.direct.utils.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

/**
 * User: xy6er
 * Date: 29.11.13
 * Time: 9:16
 */

public class BeanEqualsAssert {

    public static <T, T2> void assertThat(T actual, Matcher<T2> matcher) {
        assertThat("", actual, matcher);
    }

    public static <T, T2> void assertThat(String reason, T actual, Matcher<T2> matcher) {
        if (!matcher.matches(actual)) {
            Description description = new StringDescription();
            description.appendText(reason)
                    .appendText("\nExpected: ")
                    .appendDescriptionOf(matcher)
                    .appendText("\n     but: ");
            matcher.describeMismatch(actual, description);

            throw new AssertionError(description.toString());
        }
    }

}
