package ru.yandex.autotests.direct.utils.matchers;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * Created with IntelliJ IDEA.
 * User: alexey-n
 */
public class TextResourceMatcher extends TypeSafeMatcher<String> {

    private TextResourceFormatter resourceFormatter;
    private Matcher<String> matcher;

    public TextResourceMatcher(TextResourceFormatter resourceFormatter, Matcher<String> matcher) {
        this.resourceFormatter = resourceFormatter;
        this.matcher = matcher;
    }

    @Override
    public  boolean matchesSafely(String item) {
        return matcher.matches(item);
    }

    @Override
    public void describeTo(Description description) {
        description.appendDescriptionOf(matcher).appendText("(text resource ")
                .appendValue(TextResources.getKey(resourceFormatter.getTextResource())).appendText(")");
    }

    @Override
    protected void describeMismatchSafely(String item, Description mismatchDescription) {
        matcher.describeMismatch(item, mismatchDescription);
        }

    @Factory
    public static Matcher<String> textResourceMatcher(TextResourceFormatter textResource, Matcher<String> matcher) {
        return new TextResourceMatcher(textResource, matcher);
    }
}
