package ru.yandex.autotests.direct.utils.model;

/**
 * Created by hmepas on 10.08.16.
 * Токен содержит в себе информацию о логине и id приложения, поэтому все эти
 * три параметра нужно держать вместе
 */
public class ApiAccessCredentials {
    private final String login;
    private final String token;
    private final String applicationId;

    private ApiAccessCredentials(String login, String applicationId, String token) {
        this.login = login;
        this.applicationId = applicationId;
        this.token = token;
    }

    public String getLogin() {
        return login;
    }

    public String getToken() {
        return token;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public static ApiAccessCredentialsBuilder credentials() {
        return new ApiAccessCredentialsBuilder();
    }

    public static class ApiAccessCredentialsBuilder {
        private String login;
        private String applicationId;
        private String token;

        public ApiAccessCredentialsBuilder withLogin(String login) {
            this.login = login;
            return this;
        }

        public ApiAccessCredentialsBuilder withApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public ApiAccessCredentialsBuilder withToken(String token) {
            this.token = token;
            return this;
        }

        public ApiAccessCredentials build() {
            return new ApiAccessCredentials(login, applicationId, token);
        }
    }
}
