package ru.yandex.autotests.direct.utils.model;

import com.yandex.direct.api.v5.general.ApiExceptionMessage;

import ru.yandex.autotests.direct.utils.ReflectionUtils;

/**
 * Author pavryabov
 * Date 21.07.14
 */
public class ApiException extends Exception {

    private ApiExceptionMessage faultInfo;

    public ApiExceptionMessage getFaultInfo() {
        return faultInfo;
    }

    public <T> ApiException(T exception) {
        super((String)ReflectionUtils.invokeGetter(exception, "Message"));
        this.faultInfo = (ApiExceptionMessage)ReflectionUtils.invokeGetter(exception, "FaultInfo");
    }
}
