package ru.yandex.autotests.direct.utils.model;

import java.lang.reflect.Array;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.beanutils.BeanMap;

import ru.yandex.autotests.direct.utils.ReflectionUtils;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;


/**
 * Created by mariabye on 05.02.14.
 */
public class ModelBeanMap<T extends BeanMap> extends BeanMap {
    public ModelBeanMap() {
        super();
    }

    public ModelBeanMap(String packageName, String clazz) {
        super(ReflectionUtils.getInstance(packageName, clazz));
    }

    @SuppressWarnings("unchecked")
    public T put(String fieldName, Object value) {
        super.put(fieldName, value);
        return (T) this;
    }

    public <X extends BeanMap> T putBeanMap(String fieldName, X beanMap) {
        return put(fieldName, beanMap == null ? null : beanMap.getBean());
    }

    public <X extends BeanMap> T putBeanMapList(String fieldName, X[] beanMapArray) {
        return put(fieldName, beanMapArray == null ? null :
                Stream.of(beanMapArray).map(BeanMap::getBean).collect(Collectors.toList()));
    }

    public String toString() {
        return JsonUtils.toString(getBean());
    }

    public String getPackageName() {
        return getBean().getClass().getPackage().getName();
    }

    @SuppressWarnings("unchecked")
    public T[] emptyArray() {
        return (T[]) Array.newInstance(this.getClass(), 0);
    }

    public Object[] emptyBeanArray() {
        return (Object[]) Array.newInstance(getBean().getClass(), 0);
    }
}
