package ru.yandex.autotests.direct.utils.model;

import ru.yandex.autotests.direct.utils.DirectUtilsException;
import ru.yandex.autotests.direct.utils.mongo.UserMongoHelper;

import java.util.List;

/**
 * Created by pavryabov on 02.07.15.
 */
public class MongoUser {

    private static UserMongoHelper userMongoHelper = new UserMongoHelper();

    //Using in ppctest-handles. It's not recommended to use this method in tests.
    public static List<MongoUser> getAll() {
        return userMongoHelper.getAllUserBeans();
    }

    public static MongoUser get(String login) {
        MongoUser user = userMongoHelper.getUser(login);
        if (user == null) {
            user = new MongoUser();
            user.setLogin(login);
        }
        return user;
    }

    public static void saveUser(String login, String password) {
        MongoUser user = new MongoUser();
        user.setLogin(login);
        user.setPassword(password);
        saveUser(user);
    }

    public static void saveUser(MongoUser user) {
        if (user.getLogin() == null) {
            throw new DirectUtilsException("User can not be save with null login");
        }
        if (user.getPassword() == null) {
            throw new DirectUtilsException("User can not be save with null password");
        }
        userMongoHelper.addMongoBean(user);
    }

    public static void removeUser(String login) {
        userMongoHelper.deleteUser(login);
    }

    private String login;
    private String password;
    private String token;
    private String financeToken;
    private String sandboxToken;
    private String paymentToken;
    private int expectedShard;

    @Deprecated
    private transient String certName;

    public String getCertName() {
        return certName;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getFinanceToken() {
        return financeToken;
    }

    public void setFinanceToken(String financeToken) {
        this.financeToken = financeToken;
    }

    public String getSandboxToken() {
        return sandboxToken;
    }

    public void setSandboxToken(String sandboxToken) {
        this.sandboxToken = sandboxToken;
    }

    public String getPaymentToken() {
        return paymentToken;
    }

    public void setPaymentToken(String paymentToken) {
        this.paymentToken = paymentToken;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }

    public int getExpectedShard() {
        return expectedShard;
    }

    public void setExpectedShard(int expectedShard) {
        this.expectedShard = expectedShard;
    }

    @Override
    public String toString() {
        return "User: " + login;
    }
}
