package ru.yandex.autotests.direct.utils.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

import static java.util.stream.Collectors.toList;

/**
 * Created by IntelliJ IDEA.
 * User: mariabye
 * Date: 11.09.12
 * Time: 18:29
 * To change this template use File | Settings | File Templates.
 */
public enum RegionIDValues {
    MOSCOW(213),
    SPB(2),
    MOSCOW_AND_MOSCOW_REGION(1),
    TURKEY(983),
    ENGLAND(102),
    UKRAINE(187),
    BELARUS(149),
    RUSSIA(225),
    RUSSIA_COUNTRY(225),
    RUSSIA_CENTER(3),
    KAZAKHSTAN(159),
    KIEV(143),
    CHERNOGOLOVKA(219),
    ZELENOGRAD(216),
    CRIMEA(977),
    SEVASTOPOL(959),
    SNG(166),
    EUROPE(111),
    ASIA(183),
    AFRICA(241),
    AUSTRALIA(138),
    NORTH_AMERICA(10002),
    SOUTH_AMERICA(10003),
    GERMANY(96),
    WHOLE_WORLD(0),
    UZBEKISTAN(171),
    BS_MOON(20001);

    Integer id;

    RegionIDValues(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return id;
    }

    private static final List<RegionIDValues> VALUES = Collections.unmodifiableList(Arrays.asList(values()));
    private static final Random RANDOM = new Random();

    public static final List<RegionIDValues> WORLD_EXPANDED = Arrays.asList(EUROPE, AUSTRALIA, SNG, ASIA, RUSSIA,
            AFRICA, CRIMEA, NORTH_AMERICA, SOUTH_AMERICA);
    public static final List<Long> WORLD_EXPANDED_LONG = WORLD_EXPANDED.stream()
            .map(v -> (long) v.getId()).collect(toList());

    public static Integer getRandomId() {
        return RegionIDValues.values()[RANDOM.nextInt(VALUES.size())].getId();
    }
}
