package ru.yandex.autotests.direct.utils.money;

/**
 * Created by mariabye on 10.02.14.
 */
public enum Currency {
    YND_FIXED(null, -1),
    RUB("RUB", 643),
    UAH("UAH", 980),
    KZT("KZT", 398),
    EUR("EUR", 978),
    USD("USD", 840),
    CHF("CHF", 756),
    TRY("TRY", 949),
    BYN("BYN", 933),
    GBP("GBP", 826);

    private final String currency;
    private final int isoCode;

    Currency(String currency, int isoCode) {
        this.currency = currency;
        this.isoCode = isoCode;
    }

    @Override
    public String toString() {
        return currency;
    }

    public int getIsoCode() {
        return isoCode;
    }

    public String value() {
        if (currency != null) {
            return currency;
        } else {
            return "YND_FIXED";
        }
    }

    public static Currency getFor(String currency) {
        if (currency == null) {
            return YND_FIXED;
        } else {
            return Currency.valueOf(currency);
        }
    }

}
