package ru.yandex.autotests.direct.utils.money;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.autotests.direct.utils.beans.MongoBeanLoader;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class MoneyCurrency {
    /**
     * Ресурс для хранения специфичных для языка параметров валюты
     */
    private final static String CURRENCIES_BUNDLE = "Currencies";

    /**
     * Название коллекции с данными в монго
     */
    private final static String DATA_COLLECTION = "ConstantCurrencies";

    private final static Map<Currency, MoneyCurrency> currencies = new HashMap<>();

    /**
     * Валюта
     */
    private Currency currency;

    /**
     * Описание валюты в сообщениях api
     */
    private String apiDescription;

    /**
     * Минимальная ставка
     */
    private Money minPrice;

    /**
     * Дефолтная ставка
     */
    private Money defaultPrice;

    /**
     * Шаг торгов
     */
    private Money stepPrice;

    /**
     * Максимальная ставка
     */
    private Money maxPrice;

    /**
     * Максимальный CPA в стратегии PayForConversion
     */
    private Money maxPayForConversionCpa;

    /**
     * Мин платеж (она же для подсветки больших значений ставок в камп.)
     */
    private Money minInvoiceAmount;

    /**
     * Мин сумма нотификации при которой мы считаем, что это платеж, совершенный пользователем, а не открутка
     */
    private Money minInvoiceInterpretation;

    /**
     * Дефолтное значение цены в конструкторе ставок
     */
    private Money defaultPriceConstructorAmount;

    /**
     * Мин платеж для сервисирования
     */
    private Money minServicedInvoiceAmount;

    /**
     * Мин сумма переноса
     */
    private Money minTransferAmount;

    /**
     * Умолчальная подсказка платежа
     */
    private Money defaultPaymentHintAmount;

    /**
     * Макс. сумма подсказки суммы счета
     */
    private Money maxPaymentHintAmount;

    /**
     * Мин сумма дневного бюджета
     */
    private Money minDayBudgetAmount;

    /**
     * Мин. ставка для автобюджета "Средней цены"
     */
    private Money minAveragePrice;

    /**
     * Мин ставка для автобюджета
     */
    private Money minAutoBudgetPrice;

    /**
     * Мин. ставка для картинки
     */
    private Money minAdImagePrice;

    /**
     * Ограничения ставок для МФА-сайтов
     */
    private Money mfaPriceLimitation;

    /**
     * Мин сумма нед бюджета
     */
    private Money minWeeklyBudgetAmount;

    /**
     * Макс сумма нед бюджета
     */
    private Money maxWeeklyBudgetAmount;

    /**
     * Мин средняя цена конверсии для стратегии "Средняя цена конверсии"
     */
    private Money minAverageConversionPrice;

    /**
     * Минимальная сумма, которая должна оставаться на активной кампании после переноса
     */
    private Money minTransferRest;

    /**
     * Количество знаков после запятой для округление ставок
     */
    private int defaultPrecision;

    /**
     * Курс валюты относительно у.е.
     */
    private double rate;

    /**
     * Ставка НДС
     */
    private double vatRate;

    /**
     * Включен ли НДС в стоимость у.е.
     */
    private boolean isVATIncludedInRate;

    /**
     * Максимальное количество кликов для стратегии "Пакет кликов"
     */
    private int maxClicksPerWeek;

    /**
     * точность конвертации цен, возвращаемых из БК, из фишек в валюту
     */
    private float convertPrecision;

    /**
     * Минимальная CPM ставка
     */
    private Money minCpmPrice;

    /**
     * минимальная цена за просмотр
     */
    private Money minAvgCpv;

    /**
     * Максимальная CPM ставка
     */
    private Money maxCpmPrice;

    /**
     * Минимальный дневной бюджет
     */
    private Money minDailyBudgetForPeriod;

    /**
     * Максимальный дневной бюджет
     */
    private Money maxDailyBudgetForPeriod;

    /**
     * Максимальная средняя цена конверсии
     */
    private Money maxAutobudgetAvgCpa;

    public String getApiDescription() {
        return apiDescription;
    }

    public static MoneyCurrency get(Currency currency) {
        if (currency == null) {
            currency = Currency.YND_FIXED;
        }
        if (currencies.get(currency) == null) {
            MongoBeanLoader<MoneyCurrency> loader = new MongoBeanLoader<>(MoneyCurrency.class, DATA_COLLECTION);
            currencies.put(currency, loader.getBean(currency.value()));
        }
        return currencies.get(currency);
    }

    public Currency getCurrency() {
        return currency;
    }

    public String getFormatPattern(String locale) {
        TextResourceFormatter resourceFormatter =
                TextResourceFormatter.resource(CurrencyTextResources.valueOf(currency.name() + "_PATTERN"))
                        .locale(locale);
        return resourceFormatter.toString();
    }

    public String getAbbreviation(String locale) {
        TextResourceFormatter resourceFormatter =
                TextResourceFormatter.resource(CurrencyTextResources.valueOf(currency.name() + "_ABBREVIATION"))
                        .locale(locale);
        return resourceFormatter.toString();
    }

    public String getJavaAPIAbbreviation(String locale) {
        TextResourceFormatter resourceFormatter =
                TextResourceFormatter.resource(CurrencyTextResources.valueOf(currency.name() +
                        "_JAVA_API_ABBREVIATION"))
                        .locale(locale);
        return resourceFormatter.toString();
    }

    public String getAPIAbbreviation(String locale) {
        TextResourceFormatter resourceFormatter =
                TextResourceFormatter.resource(CurrencyTextResources.valueOf(currency.name() + "_API_ABBREVIATION"))
                        .locale(locale);
        return resourceFormatter.toString();
    }

    public String getNameCasusDativus(String locale) {
        TextResourceFormatter resourceFormatter =
                TextResourceFormatter.resource(CurrencyTextResources.valueOf(currency.name() + "_CASUS_DATIVUS"))
                        .locale(locale);
        return resourceFormatter.toString();
    }

    public String getNamePluralI(String locale) {
        TextResourceFormatter resourceFormatter =
                TextResourceFormatter.resource(CurrencyTextResources.valueOf(currency.name() + "_NAME_PLURAL_I"))
                        .locale(locale);
        return resourceFormatter.toString();
    }

    public Money getMinPrice() {
        return minPrice;
    }

    public Money getLongMinPrice() {
        return minPrice.multiply(1000000L);
    }

    public Money getDefaultPrice() {
        return defaultPrice;
    }

    public Money getLongDefaultPrice() {
        return defaultPrice.multiply(1_000_000L);
    }

    public Money getMinInvoiceInterpretation() {
        return minInvoiceInterpretation;
    }

    public Money getStepPrice() {
        return stepPrice;
    }

    public Money getLongMaxPrice() {
        return maxPrice.multiply(1000000L);
    }

    public Money getMaxPrice() {
        return maxPrice;
    }

    public Money getMaxPayForConversionCpa() {
        return maxPayForConversionCpa;
    }

    public Money getMinInvoiceAmount() {
        return minInvoiceAmount;
    }

    public Money getDefaultPriceConstructorAmount() {
        return defaultPriceConstructorAmount;
    }

    public Money getMinServicedInvoiceAmount() {
        return minServicedInvoiceAmount;
    }

    public Money getMinTransferAmount() {
        return minTransferAmount;
    }

    public Money getDefaultPaymentHintAmount() {
        return defaultPaymentHintAmount;
    }

    public Money getMaxPaymentHintAmount() {
        return maxPaymentHintAmount;
    }

    public Money getMinDayBudgetAmount() {
        return minDayBudgetAmount;
    }

    public Money getMinAveragePrice() {
        return minAveragePrice;
    }

    public Money getMinAutoBudgetPrice() {
        return minAutoBudgetPrice;
    }

    public Money getMinAdImagePrice() {
        return minAdImagePrice;
    }

    public Money getMfaPriceLimitation() {
        return mfaPriceLimitation;
    }

    public Money getMinWeeklyBudgetAmount() {
        return minWeeklyBudgetAmount;
    }

    public Money getMaxWeeklyBudgetAmount() {
        return maxWeeklyBudgetAmount;
    }

    public Money getMinAverageConversionPrice() {
        return minAverageConversionPrice;
    }

    public Money getMinTransferRest() {
        return minTransferRest;
    }

    public int getDefaultPrecision() {
        return defaultPrecision;
    }

    public double getRate() {
        return rate;
    }

    public double getVatRate() {
        return vatRate;
    }

    public boolean isVATIncludedInRate() {
        return isVATIncludedInRate;
    }

    public int getMaxClicksPerWeek() {
        return maxClicksPerWeek;
    }

    public float getConvertPrecision() {
        return convertPrecision;
    }

    public Money getMinCpmPrice() {
        return minCpmPrice;
    }

    public Money getMinAvgCpv() {
        return minAvgCpv;
    }

    public Money getMaxCpmPrice() {
        return maxCpmPrice;
    }

    public Money getMaxAutobudgetAvgCpa() {
        return maxAutobudgetAvgCpa;
    }

    public Money getMinDailyBudgetForPeriod() {
        return minDailyBudgetForPeriod;
    }

    public Money getMaxDailyBudgetForPeriod() {
        return maxDailyBudgetForPeriod;
    }

    public MoneyCurrency withVatRate(double vatRate) {
        this.vatRate = vatRate;
        return this;
    }
}
