package ru.yandex.autotests.direct.utils.money;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum MoneyFormat {
    INTEGER("#0", ' ', "ru"),
    INTEGER_SEPARATED("#,##0", (char) 0xa0, "ru"),
    INTEGER_SPACE_SEPARATED("#,##0", (char) 0x20, "ru"),
    ONE_DIGIT_COMMA("#0.0", ' ', "ru"),
    ONE_DIGIT_COMMA_SEPARATED("#,##0.0", (char) 0xa0, "ru"),
    ONE_DIGIT_POINT("#0.0", ' ', "en"),
    ONE_DIGIT_POINT_SEPARATED("#,##0.0", (char) 0xa0, "en"),
    TWO_DIGITS_COMMA_SEPARATED("#,##0.00", (char) 0xa0, "ru"),
    TWO_DIGITS_COMMA("#0.00", ' ', "ru"),
    TWO_DIGITS_POINT_SEPARATED("#,##0.00", (char) 0xa0, "en"),
    TWO_DIGITS_POINT_SEPARATED_NBSP("#,##0.00", (char) 0xA0, "en"),
    TWO_DIGITS_POINT("#0.00", ' ', "en"),
    WITHOUT_EXTRA_ZEROS("#.##", ' ', "en");

    private String pattern;
    private String lang;
    private char groupSeparator;

    MoneyFormat(String pattern, char groupSeparator, String lang) {
        this.pattern = pattern;
        this.groupSeparator = groupSeparator;
        this.lang = lang;
    }

    public DecimalFormat get() {
        DecimalFormatSymbols symb = DecimalFormatSymbols.getInstance(Locale.forLanguageTag(lang));
        symb.setGroupingSeparator(groupSeparator);
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        decimalFormat.setDecimalFormatSymbols(symb);
        return decimalFormat;
    }
}
