package ru.yandex.autotests.direct.utils.mongo;

import java.util.List;

import ru.yandex.autotests.direct.utils.model.MongoUser;
import ru.yandex.autotests.irt.restheart.config.BaseMongoHelper;
import ru.yandex.autotests.irt.restheart.config.MongoDatabases;

import static java.util.Comparator.comparing;
import static java.util.stream.Collectors.toList;

/**
 * Created by pavryabov on 02.07.15.
 */
public class UserMongoHelper extends BaseMongoHelper<MongoUser> {
    private static final String COLLECTION = "TestUsers";
    private static final String QUERY_TEMPLATE = "{login:\"%s\"}";

    public UserMongoHelper() {
        super(MongoUser.class);
    }

    public MongoUser getUser(String login) {
        String query = String.format(QUERY_TEMPLATE, login);
        return getMongoBean(query);
    }

    public void deleteUser(String login) {
        String query = String.format(QUERY_TEMPLATE, login);
        deleteMongoBean(query);
    }

    public List<MongoUser> getAllUserBeans() {
        List<MongoUser> users = getMongoBeans("{}");
        return users.stream().sorted(comparing(MongoUser::getLogin)).collect(toList());
    }

    @Override
    public String getUniqueFilter(MongoUser user) {
        return String.format(QUERY_TEMPLATE, user.getLogin());
    }

    @Override
    public String getCollection() {
        return COLLECTION;
    }

    @Override
    public String getDb() {
        return MongoDatabases.BEAN_TEMAPLATES.getDbName();
    }
}
