package ru.yandex.autotests.direct.utils.mongo;


import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;

import javax.ws.rs.NotFoundException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.reflect.TypeToken;

import ru.yandex.autotests.direct.utils.DirectUtilsException;
import ru.yandex.autotests.direct.utils.beans.BeanWrapper;
import ru.yandex.autotests.irt.restheart.beans.RestheartGetResponseBean;
import ru.yandex.autotests.irt.restheart.client.RestheartHttpClient;
import ru.yandex.autotests.irt.restheart.config.BaseMongoHelper;
import ru.yandex.autotests.irt.restheart.config.MongoDatabases;

public class WrappedBeansMongoHelper<T> extends BaseMongoHelper<T> {

    private String collectionName;

    private static final String QUERY_TEMPLATE =
            "{\"templateName\":\"%s\",$or:[{\"bean._class\":\"%s\"},{\"beanClassName\":\"%s\"}]}";

    private final static Gson stringGson = new GsonBuilder().registerTypeAdapter(String.class,
            (JsonDeserializer<String>) (json, typeOfT, context) -> json == null ? null : json.toString())
            .create();


    public WrappedBeansMongoHelper(Class<T> beanClass, String collectionName) {
        super(beanClass);
        this.collectionName = collectionName;
        mongoHttpClient = new RestheartHttpClient().useDB(getDb())
                .useCollection(getCollection());
    }

    public T getBean(String templateName) {
        String query = getQuery(templateName);
        try {
            RestheartGetResponseBean<String> responseBean = mongoHttpClient.get(query);

            if ((responseBean != null) && (responseBean.getResultDocuments() != null)
                    && (!responseBean.getResultDocuments().isEmpty()))
            {
                return convert(responseBean.getResultDocuments()).get(0);
            }
        } catch (NotFoundException e) {
        } catch (Exception e) {
            throw new DirectUtilsException("Exception while ", e);
        }
        return null;
    }

    public List<T> getBeans(String templateName) {
        String query = getQuery(templateName);
        try {
            RestheartGetResponseBean<String> responseBean = mongoHttpClient.get(query);
            if ((responseBean != null) && (responseBean.getResultDocuments() != null)
                    && (!responseBean.getResultDocuments().isEmpty()))
            {
                return convert(responseBean.getResultDocuments());
            }
        } catch (NotFoundException e) {
        } catch (Exception e) {
            throw new DirectUtilsException("Exception while ", e);
        }
        return null;
    }

    public void addMongoBean(String templateName, T bean) {
        BeanWrapper<T> wrapped = new BeanWrapper<>(bean, templateName);
        mongoHttpClient.add(wrapped);
    }

    private String getQuery(String templateName) {
        return String.format(QUERY_TEMPLATE, templateName, beanClass.getName(), beanClass.getName());
    }

    @Override
    public void deleteMongoBean(String templateName) {
        String query = getQuery(templateName);
        super.deleteMongoBean(query);
    }

    @Override
    public String getUniqueFilter(T t) {
        return null;
    }

    @Override
    public String getCollection() {
        return collectionName;
    }

    @Override
    public String getDb() {
        return MongoDatabases.BEAN_TEMAPLATES.getDbName();
    }

    @Override
    protected List<T> convert(List<String> beans) {
        Type type = new TypeToken<BeanWrapper<String>>() {
        }.getType();

        return super.convert(beans.stream()
                .map(t -> (BeanWrapper<String>) stringGson.fromJson(t, type))
                .map(BeanWrapper::getBean)
                .collect(Collectors.toList()));
    }
}
