package ru.yandex.autotests.direct.utils.rules;

import org.hamcrest.Matcher;

import java.util.ArrayList;
import java.util.List;

import static org.hamcrest.CoreMatchers.allOf;

/**
 * Builds special matcher used by {@link ru.yandex.autotests.direct.utils.rules.ExpectedExceptionRule}.
 * Добавлен из-за невозможности расширить стандартный класс
 */
public class ExpectedExceptionMatcherBuilder {

    private final List<Matcher<?>> fMatchers = new ArrayList<>();

    void add(Matcher<?> matcher) {
        fMatchers.add(matcher);
    }

    boolean expectsThrowable() {
        return !fMatchers.isEmpty();
    }

    Matcher<Throwable> build() {
        return allOfTheMatchers();
    }

    private Matcher<Throwable> allOfTheMatchers() {
        if (fMatchers.size() == 1) {
            return cast(fMatchers.get(0));
        }
        return allOf(castedMatchers());
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    private List<Matcher<? super Throwable>> castedMatchers() {
        return new ArrayList<>((List) fMatchers);
    }

    @SuppressWarnings("unchecked")
    private Matcher<Throwable> cast(Matcher<?> singleMatcher) {
        return (Matcher<Throwable>) singleMatcher;
    }
}