package ru.yandex.autotests.direct.utils.strategy.data;

import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

/**
 * Created by shmykov on 20.09.14.
 */
public class StrategyBoundParams {
    private static Currency currency;
    private static MoneyCurrency moneyCurrency;
    public static Float OUT_OF_LOWER_BOUND_MAX_PRICE;
    public static Float OUT_OF_LOWER_BOUND_AVERAGE_PRICE;
    public static Float OUT_OF_UPPER_BOUND_PRICE;
    public static Float OUT_OF_LOWER_BOUND_WEEKLY_SUM_LIMIT;
    public static Float OUT_OF_UPPER_BOUND_WEEKLY_SUM_LIMIT;
    public static Integer OUT_OF_UPPER_BOUND_CLICKS_PER_WEEK;
    public static Integer OUT_OF_LOWER_BOUND_CLICKS_PER_WEEK = 99;
    public static Float OUT_OF_LOWER_BOUND_ROI_COEFF = -2f;
    public static Float OUT_OF_LOWER_BOUND_PROFITABILITY = -1f;
    public static Float OUT_OF_UPPER_BOUND_PROFITABILITY = 101f;







   public static void initializeConstants() {
       Float lowerMax = prevPrice(moneyCurrency.getMinPrice(), moneyCurrency);
       if (lowerMax != 0.f) {
           OUT_OF_LOWER_BOUND_MAX_PRICE = lowerMax;
       } else {
           Money m = Money.valueOf(lowerMax, moneyCurrency.getCurrency());
           OUT_OF_LOWER_BOUND_MAX_PRICE = prevPrice(m, moneyCurrency);
       }

       Float lowerAvg = prevPrice(moneyCurrency.getMinAveragePrice(), moneyCurrency);
       if (lowerAvg != 0.f) {
           OUT_OF_LOWER_BOUND_AVERAGE_PRICE = lowerAvg;
       } else {
           Money m = Money.valueOf(lowerAvg, moneyCurrency.getCurrency());
           OUT_OF_LOWER_BOUND_AVERAGE_PRICE = prevPrice(m, moneyCurrency);
       }

       OUT_OF_UPPER_BOUND_PRICE = nextPrice(moneyCurrency.getMaxPrice(), moneyCurrency);

       OUT_OF_LOWER_BOUND_WEEKLY_SUM_LIMIT = prevPrice(moneyCurrency.getMinWeeklyBudgetAmount(), moneyCurrency);

       OUT_OF_UPPER_BOUND_WEEKLY_SUM_LIMIT =  moneyCurrency.getMaxWeeklyBudgetAmount().multiply(2.f).floatValue();

       OUT_OF_UPPER_BOUND_CLICKS_PER_WEEK = moneyCurrency.getMaxClicksPerWeek() + 1;
   }



    public static void forCurrency(Currency clientCurrency) {
        currency = clientCurrency;
        moneyCurrency = MoneyCurrency.get(clientCurrency);
    }


    private static Float nextPrice(Money money, MoneyCurrency moneyCurrency) {
        return money.add(moneyCurrency.getStepPrice()).floatValue();
    }

    private static Float prevPrice(Money money, MoneyCurrency moneyCurrency) {
        return money.subtract(moneyCurrency.getStepPrice()).floatValue();
    }
}
